/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.integration.mvn;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.ChainingDecorator;
import org.jboss.windup.decorator.integration.mvn.resp.MavenCentralSHA1VersionResponseItem;
import org.jboss.windup.decorator.integration.mvn.resp.MavenCentralSHA1VersionResponseWrapper;
import org.jboss.windup.interrogator.impl.XmlInterrogator;
import org.jboss.windup.interrogator.util.KnownArchiveProfiler;
import org.jboss.windup.metadata.decoration.Hash;
import org.jboss.windup.metadata.decoration.archetype.version.PomVersion;
import org.jboss.windup.metadata.type.XmlMetadata;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.metadata.type.archive.ZipMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class MavenCentralSHA1VersionDecorator
extends ChainingDecorator<ZipMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(MavenCentralSHA1VersionDecorator.class);
    private static final String MAVEN_API_URL = "http://search.maven.org/solrsearch/select?q=1:{query}&rows=1&wt=json";
    private static final String MAVEN_API_FILEPULL_URL = "http://search.maven.org/remotecontent?filepath=";
    private KnownArchiveProfiler knownArchiveProfiler;
    private Boolean active;
    private XmlInterrogator pomInterrogator;

    public void setKnownArchiveProfiler(KnownArchiveProfiler knownArchiveProfiler) {
        this.knownArchiveProfiler = knownArchiveProfiler;
    }

    public void setActive(String active) {
        this.active = BooleanUtils.toBooleanObject((String)active);
    }

    public void setPomInterrogator(XmlInterrogator pomInterrogator) {
        this.pomInterrogator = pomInterrogator;
    }

    @Override
    public void processMeta(ZipMetadata meta) {
        if (!this.active.booleanValue()) {
            return;
        }
        if (!this.knownArchiveProfiler.isExclusivelyKnownArchive(meta)) {
            return;
        }
        String sha1Hash = null;
        for (Object result : meta.getDecorations()) {
            if (result instanceof PomVersion) {
                LOG.debug("Already has version result: " + result.toString());
                return;
            }
            if (!(result instanceof Hash) || ((Hash)result).getHashType() != Hash.HashType.SHA1) continue;
            sha1Hash = ((Hash)result).getHash();
        }
        if (sha1Hash == null) {
            LOG.debug("No SHA-1 Hash found. Returning.");
            return;
        }
        LOG.info("No Version Found: " + meta.getRelativePath() + "; trying Maven Central");
        if (LOG.isDebugEnabled()) {
            LOG.debug("SHA1: " + sha1Hash);
        }
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(new MappingJacksonHttpMessageConverter());
        try {
            Object result;
            result = (MavenCentralSHA1VersionResponseWrapper)restTemplate.getForObject(MAVEN_API_URL, MavenCentralSHA1VersionResponseWrapper.class, new Object[]{sha1Hash});
            if (result != null && ((MavenCentralSHA1VersionResponseWrapper)result).getResponse() != null && ((MavenCentralSHA1VersionResponseWrapper)result).getResponse().getNumFound() > 0) {
                MavenCentralSHA1VersionResponseItem rsp = ((MavenCentralSHA1VersionResponseWrapper)result).getResponse().getDocs()[0];
                String groupId = rsp.getGroupId();
                String artifactId = rsp.getArtifactId();
                String version = rsp.getVersion();
                String url = this.generateUrl(groupId, artifactId, version);
                SimpleClientHttpRequestFactory request = new SimpleClientHttpRequestFactory();
                try {
                    ClientHttpRequest pomRequest = request.createRequest(new URI(url), HttpMethod.GET);
                    ClientHttpResponse resp = pomRequest.execute();
                    String outputDir = meta.getArchiveOutputDirectory().getAbsolutePath() + File.separator + "maven-remote";
                    FileUtils.forceMkdir((File)new File(outputDir));
                    File outputPath = new File(outputDir + File.separator + "pom.xml");
                    IOUtils.copy((Reader)new InputStreamReader(resp.getBody()), (OutputStream)new FileOutputStream(outputPath));
                    XmlMetadata xmlMeta = new XmlMetadata();
                    xmlMeta.setFilePointer(outputPath);
                    xmlMeta.setArchiveMeta((ArchiveMetadata)meta);
                    this.pomInterrogator.processMeta(xmlMeta);
                    LOG.info("Fetched remote POM for: " + meta.getName());
                }
                catch (Exception e) {
                    LOG.error("Exception fetching remote POM: " + url + "; skipping.", (Throwable)e);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No Version Information Found in Maven Central for: " + sha1Hash);
            }
        }
        catch (Exception e) {
            LOG.error("Exception creating API call to Central Repo for POM: " + meta.getName() + "; skipping.", (Throwable)e);
        }
    }

    protected String generateUrl(String groupId, String artifactId, String version) {
        StringBuilder url = new StringBuilder(MAVEN_API_FILEPULL_URL);
        url.append(StringUtils.replace((String)groupId, (String)".", (String)"/"));
        url.append("/" + artifactId);
        url.append("/" + version);
        url.append("/" + artifactId + "-" + version);
        url.append(".pom");
        return url.toString();
    }
}

