/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.java.decompiler;

import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.windup.decorator.java.decompiler.DecompilerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDecompilerAdapter
implements DecompilerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncDecompilerAdapter.class);
    private ExecutorService executor = Executors.newCachedThreadPool();
    private Integer timeoutSeconds;
    private DecompilerAdapter decompilerAdapter;

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setDecompilerAdapter(DecompilerAdapter decompilerAdapter) {
        this.decompilerAdapter = decompilerAdapter;
    }

    @Override
    public void decompile(String className, String classLocation, String sourceOutputLocation) {
        this.decompile(className, new File(classLocation), new File(sourceOutputLocation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompile(String className, File classLocation, File sourceOutputLocation) {
        DecompilerTask dt = new DecompilerTask(className, classLocation, sourceOutputLocation, this.decompilerAdapter);
        Future<?> future = this.executor.submit(dt);
        try {
            Object result = future.get(this.timeoutSeconds.intValue(), TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            LOG.error("Timed out execution of : " + dt.toString());
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted out execution of : " + dt.toString());
        }
        catch (ExecutionException e) {
            LOG.error("Execution execution of : " + dt.toString());
        }
        finally {
            future.cancel(true);
        }
    }

    public class DecompilerTask
    implements Runnable {
        private DecompilerAdapter decompilerAdapter;
        private String className;
        private File classLocation;
        private File sourceOutputLocation;

        public DecompilerTask(String className, File classLocation, File sourceOutputLocation, DecompilerAdapter decompilerAdapter) {
            this.classLocation = classLocation;
            this.sourceOutputLocation = sourceOutputLocation;
            this.className = className;
            this.decompilerAdapter = decompilerAdapter;
        }

        @Override
        public void run() {
            this.decompilerAdapter.decompile(this.className, this.classLocation, this.sourceOutputLocation);
        }

        public String toString() {
            return "DecompilerTask [decompilerAdapter=" + this.decompilerAdapter.getClass() + ", className=" + this.className + ", classLocation=" + this.classLocation + ", sourceOutputLocation=" + this.sourceOutputLocation + "]";
        }
    }
}

