/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.interrogator;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jboss.windup.interrogator.Interrogator;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.TempSourceMetadata;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.metadata.type.archive.DirectoryMetadata;
import org.jboss.windup.util.RecursiveDirectoryMetaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryInterrogationEngine {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryInterrogationEngine.class);
    protected List<Interrogator> interrogators;

    public void setInterrogators(List<Interrogator> interrogators) {
        this.interrogators = interrogators;
    }

    public DirectoryMetadata process(File outputDirectory, File targetDirectory) {
        RecursiveDirectoryMetaFactory rdmf = new RecursiveDirectoryMetaFactory(targetDirectory);
        LinkedList<DirectoryMetadata> directories = new LinkedList<DirectoryMetadata>();
        DirectoryMetadata root = rdmf.recursivelyExtract();
        this.unfoldRecursion(root, directories);
        int i = 1;
        int j = directories.size();
        for (DirectoryMetadata directoryMeta : directories) {
            LOG.info("Interrogating (" + i + " of " + j + "): " + directoryMeta.getRelativePath());
            Collection files = FileUtils.listFiles((File)directoryMeta.getFilePointer(), (IOFileFilter)TrueFileFilter.INSTANCE, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Processing " + files.size() + " files within directory.");
            }
            if (outputDirectory != null) {
                String dirOutput = FilenameUtils.normalize((String)FilenameUtils.separatorsToSystem((String)(outputDirectory.getAbsolutePath() + File.separatorChar + directoryMeta.getRelativePath())));
                directoryMeta.setArchiveOutputDirectory(new File(dirOutput));
            }
            for (Interrogator interrogator : this.interrogators) {
                for (File file : files) {
                    if (!file.isFile()) continue;
                    LOG.debug("Processing file: " + file.getAbsolutePath());
                    TempSourceMetadata fileMeta = new TempSourceMetadata(file);
                    fileMeta.setArchiveMeta((ArchiveMetadata)directoryMeta);
                    LOG.debug("Set archive as: " + directoryMeta);
                    interrogator.processFile((FileMetadata)fileMeta);
                }
            }
            ++i;
        }
        return root;
    }

    protected void unfoldRecursion(DirectoryMetadata base, Collection<DirectoryMetadata> archiveMetas) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Directory: " + base.getName() + " Children: " + base.getNestedArchives().size() + " Path: " + base.getFilePointer().getAbsolutePath());
        }
        for (ArchiveMetadata meta : base.getNestedArchives()) {
            DirectoryMetadata child = (DirectoryMetadata)meta;
            this.unfoldRecursion(child, archiveMetas);
        }
        archiveMetas.add(base);
    }
}

