/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.interrogator.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.jboss.windup.interrogator.impl.ExtensionInterrogator;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.JavaMetadata;
import org.jboss.windup.metadata.type.ZipEntryMetadata;
import org.jboss.windup.util.BlacklistPackageResolver;
import org.jboss.windup.util.CustomerPackageResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaInterrogator
extends ExtensionInterrogator<JavaMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaInterrogator.class);
    private BlacklistPackageResolver blacklistPackageResolver;
    private CustomerPackageResolver customerPackageResolver;

    public void setBlacklistPackageResolver(BlacklistPackageResolver blacklistPackageResolver) {
        this.blacklistPackageResolver = blacklistPackageResolver;
    }

    public void setCustomerPackageResolver(CustomerPackageResolver customerPackageResolver) {
        this.customerPackageResolver = customerPackageResolver;
    }

    @Override
    public JavaMetadata archiveEntryToMeta(ZipEntryMetadata archiveEntry) {
        File file = archiveEntry.getFilePointer();
        JavaMetadata meta = new JavaMetadata();
        meta.setArchiveMeta(archiveEntry.getArchiveMeta());
        meta.setFilePointer(file);
        this.populateMeta(meta);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing: " + file.getAbsolutePath());
            LOG.debug("Processing: " + meta.getQualifiedClassName());
        }
        if (!this.customerPackageResolver.isCustomerPkg(meta.getQualifiedClassName())) {
            LOG.trace("Not customer type: " + meta.getQualifiedClassName());
            return null;
        }
        if (this.blacklistPackageResolver.containsGenerated(meta.getClassDependencies())) {
            LOG.trace("Class is generated.  Skip profiling.");
            return null;
        }
        if (!this.blacklistPackageResolver.containsBlacklist(meta.getClassDependencies())) {
            LOG.trace("Class does not contain blacklists.");
            return null;
        }
        return meta;
    }

    @Override
    public JavaMetadata fileEntryToMeta(FileMetadata entry) {
        JavaMetadata meta = new JavaMetadata();
        meta.setFilePointer(entry.getFilePointer());
        meta.setArchiveMeta(entry.getArchiveMeta());
        this.populateMeta(meta);
        if (!this.customerPackageResolver.isCustomerPkg(meta.getQualifiedClassName())) {
            LOG.trace("Not customer package.");
            return null;
        }
        if (this.blacklistPackageResolver.containsGenerated(meta.getClassDependencies())) {
            LOG.trace("Class is generated.  Skip profiling.");
            return null;
        }
        if (!this.blacklistPackageResolver.containsBlacklist(meta.getClassDependencies())) {
            LOG.trace("Class does not contain blacklists.");
            return null;
        }
        return meta;
    }

    public void populateMeta(JavaMetadata meta) {
        List types;
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setBindingsRecovery(true);
        parser.setResolveBindings(true);
        try {
            parser.setSource(FileUtils.readFileToString((File)meta.getFilePointer()).toCharArray());
        }
        catch (IOException e) {
            LOG.error("Exception setting source for parser.", (Throwable)e);
            return;
        }
        parser.setKind(8);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        List imports = cu.imports();
        HashSet<String> clzDependencies = new HashSet<String>();
        if (imports != null) {
            for (Object id : imports) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Import: " + id.getName());
                }
                clzDependencies.add(id.getName().getFullyQualifiedName());
            }
        }
        meta.setClassDependencies(clzDependencies);
        meta.setBlackListedDependencies(this.blacklistPackageResolver.extractBlacklist(clzDependencies));
        if (LOG.isDebugEnabled()) {
            for (Object id : meta.getBlackListedDependencies()) {
                LOG.debug("Blacklist: " + (String)id);
            }
        }
        if ((types = cu.types()) != null) {
            Iterator i$ = types.iterator();
            if (i$.hasNext()) {
                TypeDeclaration type = (TypeDeclaration)i$.next();
                PackageDeclaration packageDeclaration = cu.getPackage();
                String packageName = "";
                if (packageDeclaration != null) {
                    packageName = cu.getPackage().getName().getFullyQualifiedName() + ".";
                }
                String fullPackage = packageName + type.getName().getFullyQualifiedName();
                meta.setQualifiedClassName(fullPackage);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Full Package: " + fullPackage);
                }
            }
        } else {
            LOG.warn("Expected to find Java 'type' in fine: " + meta.getPathRelativeToArchive());
        }
    }
}

