/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.interrogator.impl;

import java.io.File;
import org.jboss.windup.interrogator.impl.ExtensionInterrogator;
import org.jboss.windup.metadata.decoration.Classification;
import org.jboss.windup.metadata.decoration.effort.Effort;
import org.jboss.windup.metadata.decoration.effort.StoryPointEffort;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.ManifestMetadata;
import org.jboss.windup.metadata.type.ZipEntryMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestInterrogator
extends ExtensionInterrogator<ManifestMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestInterrogator.class);

    @Override
    public ManifestMetadata archiveEntryToMeta(ZipEntryMetadata archiveEntry) {
        File file = archiveEntry.getFilePointer();
        LOG.debug("Processing Manifest: " + file.getAbsolutePath().toString());
        if (file.length() > 0x100000L) {
            LOG.warn("Manifest larger than 1 MB: " + file.getAbsolutePath() + "; Skipping processing.");
            return null;
        }
        ManifestMetadata meta = new ManifestMetadata();
        meta.setArchiveMeta(archiveEntry.getArchiveMeta());
        meta.setFilePointer(file);
        Classification classification = new Classification();
        StoryPointEffort he = new StoryPointEffort();
        he.setHours(Integer.valueOf(0));
        classification.setEffort((Effort)he);
        classification.setDescription("ArchiveMetadata Manifest");
        meta.getDecorations().add(classification);
        return meta;
    }

    @Override
    public ManifestMetadata fileEntryToMeta(FileMetadata entry) {
        File file = entry.getFilePointer();
        LOG.debug("Processing Manifest: " + file.getAbsolutePath().toString());
        if (file.length() > 0x100000L) {
            LOG.warn("Manifest larger than 1 MB: " + file.getAbsolutePath() + "; Skipping processing.");
            return null;
        }
        ManifestMetadata meta = new ManifestMetadata();
        meta.setFilePointer(file);
        meta.setArchiveMeta(entry.getArchiveMeta());
        Classification classification = new Classification();
        StoryPointEffort he = new StoryPointEffort();
        he.setHours(Integer.valueOf(0));
        classification.setEffort((Effort)he);
        classification.setDescription("ArchiveMetadata Manifest");
        meta.getDecorations().add(classification);
        return meta;
    }
}

