/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.interrogator.impl;

import java.io.File;
import org.jboss.windup.interrogator.impl.ExtensionInterrogator;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.decoration.Summary;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.XmlMetadata;
import org.jboss.windup.metadata.type.ZipEntryMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XmlInterrogator
extends ExtensionInterrogator<XmlMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(XmlInterrogator.class);

    @Override
    public void processMeta(XmlMetadata fileMeta) {
        Document document = fileMeta.getParsedDocument();
        if (document == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Document was null.  Problem parsing: " + fileMeta.getFilePointer().getAbsolutePath());
            }
            fileMeta.getArchiveMeta().getEntries().add(fileMeta);
            return;
        }
        super.processMeta(fileMeta);
    }

    @Override
    public boolean isOfInterest(XmlMetadata fileMeta) {
        return true;
    }

    @Override
    public XmlMetadata archiveEntryToMeta(ZipEntryMetadata archiveEntry) {
        File file = archiveEntry.getFilePointer();
        LOG.debug("Processing XML: " + file.getAbsolutePath());
        XmlMetadata meta = null;
        if (file.length() <= 0x100000L) {
            XmlMetadata xmlMeta = new XmlMetadata();
            xmlMeta.setArchiveMeta(archiveEntry.getArchiveMeta());
            xmlMeta.setFilePointer(file);
            meta = xmlMeta;
            return xmlMeta;
        }
        LOG.warn("XML larger than 1 MB: " + file.getAbsolutePath() + "; Skipping processing.");
        meta = new FileMetadata();
        meta.setArchiveMeta(archiveEntry.getArchiveMeta());
        meta.setFilePointer(file);
        Summary sr = new Summary();
        sr.setDescription("File is too large; skipped.");
        sr.setLevel(AbstractDecoration.NotificationLevel.WARNING);
        meta.getDecorations().add(sr);
        return null;
    }

    @Override
    public XmlMetadata fileEntryToMeta(FileMetadata entry) {
        File file = entry.getFilePointer();
        LOG.debug("Processing XML: " + file.getAbsolutePath());
        XmlMetadata meta = null;
        if (file.length() <= 0x100000L) {
            XmlMetadata xmlMeta = new XmlMetadata();
            xmlMeta.setArchiveMeta(entry.getArchiveMeta());
            xmlMeta.setFilePointer(file);
            meta = xmlMeta;
            return xmlMeta;
        }
        LOG.warn("XML larger than 1 MB: " + file.getAbsolutePath() + "; Skipping processing.");
        meta = new FileMetadata();
        meta.setFilePointer(file);
        meta.setArchiveMeta(entry.getArchiveMeta());
        Summary sr = new Summary();
        sr.setDescription("File is too large; skipped.");
        sr.setLevel(AbstractDecoration.NotificationLevel.WARNING);
        meta.getDecorations().add(sr);
        return null;
    }
}

