/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerPackageResolver {
    private static final Logger LOG = LoggerFactory.getLogger(CustomerPackageResolver.class);
    private Set<String> customerPackages = new HashSet<String>();
    private Set<String> excludePackages = new HashSet<String>();

    public Set<String> getExcludePackages() {
        return this.excludePackages;
    }

    public Set<String> getCustomerPackages() {
        return this.customerPackages;
    }

    public CustomerPackageResolver(String packageSignatures, String excludeSignatures) {
        this.populateSignature(packageSignatures, this.customerPackages);
        this.populateSignature(excludeSignatures, this.excludePackages);
    }

    public void populateSignature(String raw, Set<String> signatures) {
        String[] splitSignatures;
        if (StringUtils.isNotBlank((String)raw) && (splitSignatures = StringUtils.split((String)raw, (String)":")) != null && splitSignatures.length > 0) {
            for (String pkg : splitSignatures) {
                LOG.info("Found Package: " + pkg);
            }
            signatures.addAll(Arrays.asList(splitSignatures));
        }
    }

    public boolean isCustomerPkg(String className) {
        for (String excludePackage : this.excludePackages) {
            if (!StringUtils.startsWith((String)className, (String)excludePackage)) continue;
            return false;
        }
        for (String customerPackage : this.customerPackages) {
            if (!StringUtils.startsWith((String)className, (String)customerPackage)) continue;
            return true;
        }
        return false;
    }
}

