/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.impl.lucene.AbstractCommitPolicy;
import org.hibernate.search.backend.impl.lucene.IndexWriterHolder;

public final class PerChangeSetCommitPolicy
extends AbstractCommitPolicy {
    public PerChangeSetCommitPolicy(IndexWriterHolder indexWriterHolder) {
        super(indexWriterHolder);
    }

    @Override
    public void onChangeSetApplied(boolean someFailureHappened, boolean streaming) {
        if (someFailureHappened) {
            this.indexWriterHolder.forceLockRelease();
        } else if (!streaming) {
            this.indexWriterHolder.commitIndexWriter();
        }
    }

    @Override
    public void onFlush() {
        this.indexWriterHolder.commitIndexWriter();
    }

    @Override
    public IndexWriter getIndexWriter() {
        return this.indexWriterHolder.getIndexWriter();
    }
}

