/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.engine.impl.nullencoding.NotEncodingCodec;
import org.hibernate.search.engine.impl.nullencoding.NullMarkerCodec;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;

public class DocumentFieldMetadata {
    private final String fieldName;
    private final Store store;
    private final Field.Index index;
    private final Field.TermVector termVector;
    private final FieldBridge fieldBridge;
    private final Float boost;
    private final Analyzer analyzer;
    private final boolean isId;
    private final boolean isIdInEmbedded;
    private final NullMarkerCodec nullMarkerCodec;
    private final boolean isNumeric;
    private final boolean isSpatial;
    private final int precisionStep;
    private final NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType;
    private final Set<FacetMetadata> facetMetadata;

    private DocumentFieldMetadata(Builder builder) {
        this.fieldName = builder.fieldName;
        this.store = builder.store;
        this.index = builder.index;
        this.termVector = builder.termVector;
        this.fieldBridge = builder.fieldBridge;
        this.boost = builder.boost;
        this.analyzer = builder.analyzer;
        this.isId = builder.isId;
        this.isIdInEmbedded = builder.isIdInEmbedded;
        this.nullMarkerCodec = builder.nullMarkerCodec;
        this.isNumeric = builder.isNumeric;
        this.isSpatial = builder.isSpatial;
        this.precisionStep = builder.precisionStep;
        this.numericEncodingType = builder.numericEncodingType;
        this.facetMetadata = Collections.unmodifiableSet(builder.facetMetadata);
    }

    public String getName() {
        return this.fieldName;
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isIdInEmbedded() {
        return this.isIdInEmbedded;
    }

    public Store getStore() {
        return this.store;
    }

    public Field.Index getIndex() {
        return this.index;
    }

    public Field.TermVector getTermVector() {
        return this.termVector;
    }

    public FieldBridge getFieldBridge() {
        return this.fieldBridge;
    }

    public Float getBoost() {
        return this.boost;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public String indexNullAs() {
        return this.nullMarkerCodec.nullRepresentedAsString();
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public boolean isSpatial() {
        return this.isSpatial;
    }

    public Integer getPrecisionStep() {
        return this.precisionStep;
    }

    public NumericFieldSettingsDescriptor.NumericEncodingType getNumericEncodingType() {
        return this.numericEncodingType;
    }

    public boolean hasFacets() {
        return !this.facetMetadata.isEmpty();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Set<FacetMetadata> getFacetMetadata() {
        return this.facetMetadata;
    }

    public String toString() {
        return "DocumentFieldMetadata{fieldName='" + this.fieldName + '\'' + ", store=" + (Object)((Object)this.store) + ", index=" + this.index + ", termVector=" + this.termVector + ", fieldBridge=" + this.fieldBridge + ", boost=" + this.boost + ", analyzer=" + this.analyzer + ", isId=" + this.isId + ", isIdInEmbedded=" + this.isIdInEmbedded + ", nullToken='" + this.nullMarkerCodec.nullRepresentedAsString() + '\'' + ", isNumeric=" + this.isNumeric + ", isSpatial=" + this.isSpatial + ", precisionStep=" + this.precisionStep + ", numericEncodingType=" + (Object)((Object)this.numericEncodingType) + ", facetMetadata=" + this.facetMetadata + '}';
    }

    public static class Builder {
        private final String fieldName;
        private final Store store;
        private final Field.Index index;
        private final Field.TermVector termVector;
        private FieldBridge fieldBridge;
        private Float boost;
        private Analyzer analyzer;
        private boolean isId;
        private boolean isIdInEmbedded;
        private boolean isNumeric;
        private boolean isSpatial;
        private int precisionStep = 4;
        private NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType;
        private Set<FacetMetadata> facetMetadata;
        private NullMarkerCodec nullMarkerCodec = NotEncodingCodec.SINGLETON;

        public Builder(String fieldName, Store store, Field.Index index, Field.TermVector termVector) {
            this.fieldName = fieldName;
            this.store = store;
            this.index = index;
            this.termVector = termVector;
            this.facetMetadata = new HashSet<FacetMetadata>(1);
        }

        public Builder fieldBridge(FieldBridge fieldBridge) {
            this.fieldBridge = fieldBridge;
            return this;
        }

        public Builder boost(Float boost) {
            this.boost = boost;
            return this;
        }

        public Builder analyzer(Analyzer analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public Builder id() {
            this.isId = true;
            return this;
        }

        public Builder idInEmbedded() {
            this.isIdInEmbedded = true;
            return this;
        }

        public Builder indexNullAs(NullMarkerCodec nullMarkerCodec) {
            this.nullMarkerCodec = nullMarkerCodec;
            return this;
        }

        public Builder numeric() {
            this.isNumeric = true;
            return this;
        }

        public Builder spatial() {
            this.isSpatial = true;
            return this;
        }

        public Builder precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return this;
        }

        public Builder numericEncodingType(NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType) {
            this.numericEncodingType = numericEncodingType;
            return this;
        }

        public Builder addFacetMetadata(FacetMetadata facetMetadata) {
            this.facetMetadata.add(facetMetadata);
            return this;
        }

        public DocumentFieldMetadata build() {
            return new DocumentFieldMetadata(this);
        }

        public String toString() {
            return "Builder{fieldName='" + this.fieldName + '\'' + '}';
        }
    }
}

