/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.engine.ConstraintValidatorContextImpl;
import org.hibernate.validator.engine.MessageAndPath;
import org.hibernate.validator.engine.MethodValidationContext;
import org.hibernate.validator.engine.PathImpl;
import org.hibernate.validator.engine.ValueContext;
import org.hibernate.validator.util.IdentitySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis.
 */
public abstract class ValidationContext<T, C extends ConstraintViolation<T>> {
    private final T rootBean;
    private final Class<T> rootBeanClass;
    private final Map<Class<?>, IdentitySet> processedObjects;
    private final Map<Object, Set<PathImpl>> processedPaths;
    private final Set<C> failingConstraintViolations;
    private boolean allowOneValidationPerPath;
    protected final MessageInterpolator messageInterpolator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final TraversableResolver traversableResolver;
    private final boolean failFast;

    public static <T> ValidationContext<T, ConstraintViolation<T>> getContextForValidate(T var0, MessageInterpolator var1, ConstraintValidatorFactory var2, TraversableResolver var3, boolean var4);

    public static <T> ValidationContext<T, ConstraintViolation<T>> getContextForValidateProperty(T var0, MessageInterpolator var1, ConstraintValidatorFactory var2, TraversableResolver var3, boolean var4);

    public static <T> ValidationContext<T, ConstraintViolation<T>> getContextForValidateValue(Class<T> var0, MessageInterpolator var1, ConstraintValidatorFactory var2, TraversableResolver var3, boolean var4);

    public static <T> MethodValidationContext<T> getContextForValidateParameter(Method var0, int var1, T var2, MessageInterpolator var3, ConstraintValidatorFactory var4, TraversableResolver var5, boolean var6);

    public static <T> MethodValidationContext<T> getContextForValidateParameters(Method var0, T var1, MessageInterpolator var2, ConstraintValidatorFactory var3, TraversableResolver var4, boolean var5);

    protected ValidationContext(Class<T> var1, T var2, MessageInterpolator var3, ConstraintValidatorFactory var4, TraversableResolver var5, boolean var6);

    public final T getRootBean();

    public final Class<T> getRootBeanClass();

    public final TraversableResolver getTraversableResolver();

    public final MessageInterpolator getMessageInterpolator();

    public final boolean shouldFailFast();

    public abstract <U, V> C createConstraintViolation(ValueContext<U, V> var1, MessageAndPath var2, ConstraintDescriptor<?> var3);

    public final <U, V> List<C> createConstraintViolations(ValueContext<U, V> var1, ConstraintValidatorContextImpl var2);

    public final ConstraintValidatorFactory getConstraintValidatorFactory();

    public boolean isAlreadyValidated(Object var1, Class<?> var2, PathImpl var3);

    public void markProcessed(Object var1, Class<?> var2, PathImpl var3);

    public final void addConstraintFailures(Set<C> var1);

    public Set<C> getFailingConstraints();

    private boolean isAlreadyValidatedForPath(Object var1, PathImpl var2);

    private boolean isSubPathOf(Path var1, Path var2);

    private boolean isAlreadyValidatedForCurrentGroup(Object var1, Class<?> var2);

    private void markProcessedForCurrentPath(Object var1, PathImpl var2);

    private void markProcessForCurrentGroup(Object var1, Class<?> var2);
}

