/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.agentclient.impl;

import org.rhq.core.clientapi.agent.bundle.BundleAgentService;
import org.rhq.core.clientapi.agent.configuration.ConfigurationAgentService;
import org.rhq.core.clientapi.agent.content.ContentAgentService;
import org.rhq.core.clientapi.agent.discovery.DiscoveryAgentService;
import org.rhq.core.clientapi.agent.inventory.ResourceFactoryAgentService;
import org.rhq.core.clientapi.agent.measurement.MeasurementAgentService;
import org.rhq.core.clientapi.agent.operation.OperationAgentService;
import org.rhq.core.clientapi.agent.support.SupportAgentService;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.server.ExternalizableStrategy;
import org.rhq.enterprise.communications.Ping;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.ClientRemotePojoFactory;
import org.rhq.enterprise.communications.command.client.SendCallback;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.util.HibernateDetachUtility;

public class AgentClientImpl
implements AgentClient {
    private final Agent agent;
    private final ClientCommandSender sender;
    private final ClientRemotePojoFactory clientRemotePojoFactory;

    public AgentClientImpl(Agent agent, ClientCommandSender sender) {
        if (agent == null) {
            throw new IllegalArgumentException("agent==null");
        }
        if (sender == null) {
            throw new IllegalArgumentException("sender==null");
        }
        this.agent = agent;
        this.sender = sender;
        this.clientRemotePojoFactory = sender.getClientRemotePojoFactory();
        this.sender.setSendCallbacks(new SendCallback[]{new ExternalizableStrategySendCallback()});
        this.clientRemotePojoFactory.setDeliveryGuaranteed(ClientRemotePojoFactory.GuaranteedDelivery.DISABLED);
    }

    public Agent getAgent() {
        return this.agent;
    }

    public String toString() {
        return this.getAgent().toString();
    }

    public void startSending() {
        this.sender.startSending();
    }

    public void stopSending() {
        this.sender.stopSending(false);
    }

    public boolean ping(long timeoutMillis) {
        try {
            ClientRemotePojoFactory factory = this.sender.getClientRemotePojoFactory();
            factory.setTimeout(Long.valueOf(timeoutMillis));
            Ping pinger = (Ping)factory.getRemotePojo(Ping.class);
            pinger.ping("", null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BundleAgentService getBundleAgentService() {
        return (BundleAgentService)this.clientRemotePojoFactory.getRemotePojo(BundleAgentService.class);
    }

    public ContentAgentService getContentAgentService() {
        return (ContentAgentService)this.clientRemotePojoFactory.getRemotePojo(ContentAgentService.class);
    }

    public ResourceFactoryAgentService getResourceFactoryAgentService() {
        return (ResourceFactoryAgentService)this.clientRemotePojoFactory.getRemotePojo(ResourceFactoryAgentService.class);
    }

    public DiscoveryAgentService getDiscoveryAgentService() {
        return (DiscoveryAgentService)this.clientRemotePojoFactory.getRemotePojo(DiscoveryAgentService.class);
    }

    public MeasurementAgentService getMeasurementAgentService() {
        return (MeasurementAgentService)this.clientRemotePojoFactory.getRemotePojo(MeasurementAgentService.class);
    }

    public OperationAgentService getOperationAgentService() {
        return (OperationAgentService)this.clientRemotePojoFactory.getRemotePojo(OperationAgentService.class);
    }

    public ConfigurationAgentService getConfigurationAgentService() {
        return (ConfigurationAgentService)this.clientRemotePojoFactory.getRemotePojo(ConfigurationAgentService.class);
    }

    public SupportAgentService getSupportAgentService() {
        return (SupportAgentService)this.clientRemotePojoFactory.getRemotePojo(SupportAgentService.class);
    }

    private static class ExternalizableStrategySendCallback
    implements SendCallback {
        public void sending(Command command) {
            try {
                HibernateDetachUtility.nullOutUninitializedFields((Object)command, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ExternalizableStrategy.setStrategy((ExternalizableStrategy.Subsystem)ExternalizableStrategy.Subsystem.AGENT);
        }

        public CommandResponse sent(Command command, CommandResponse response) {
            return response;
        }
    }
}

