/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.alert.engine.internal.AlertConditionCacheCoordinator;
import org.rhq.enterprise.server.alert.engine.jms.CachedConditionProducerLocal;
import org.rhq.enterprise.server.alert.engine.model.AbstractCacheElement;
import org.rhq.enterprise.server.alert.engine.model.AlertConditionOperator;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractConditionCache {
    static final Log log = LogFactory.getLog(AlertConditionCacheCoordinator.class);
    static final int PAGE_SIZE = 250;
    private CachedConditionProducerLocal cachedConditionProducer = LookupUtil.getCachedConditionProducerLocal();

    <T extends AbstractCacheElement<S>, S> void processCacheElements(List<T> cacheElements, S providedValue, long timestamp, AlertConditionCacheStats stats, Object ... extraParams) {
        if (cacheElements == null) {
            return;
        }
        int errors = 0;
        for (AbstractCacheElement cacheElement : cacheElements) {
            boolean matched = cacheElement.process(providedValue, extraParams);
            if (matched) {
                try {
                    cacheElement.setActive(true);
                    this.cachedConditionProducer.sendActivateAlertConditionMessage(cacheElement.getAlertConditionTriggerId(), timestamp, cacheElement.convertValueToString(providedValue), extraParams);
                    ++stats.matched;
                }
                catch (Exception e) {
                    log.error((Object)("Error processing matched cache element '" + cacheElement + "': " + e.getMessage()));
                    ++errors;
                }
                continue;
            }
            if (!cacheElement.isType(AlertConditionOperator.Type.STATEFUL) || !cacheElement.isActive()) continue;
            cacheElement.setActive(false);
            try {
                this.cachedConditionProducer.sendDeactivateAlertConditionMessage(cacheElement.getAlertConditionTriggerId(), timestamp);
            }
            catch (Exception e) {
                log.error((Object)("Error sending deactivation message for cache element '" + cacheElement + "': " + e.getMessage()));
                ++errors;
            }
        }
        if (errors != 0) {
            log.error((Object)("There were " + errors + " alert conditions that did not fire. " + "Please check the configuration of the JMS subsystem and try again. "));
        }
    }

    <T extends AbstractCacheElement<?>> boolean addTo(String mapName, Map<Integer, List<T>> cache, Integer key, T cacheElement, int alertConditionId, AlertConditionCacheStats stats) {
        boolean success;
        List<T> cacheElements = cache.get(key);
        if (cacheElements == null) {
            cacheElements = new ArrayList<T>();
            cache.put(key, cacheElements);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserted '" + mapName + "' element: " + "key=" + key + ", " + "value=" + cacheElement));
        }
        if (success = cacheElements.add(cacheElement)) {
            ++stats.created;
        }
        return success;
    }

    public abstract int getCacheSize(AlertConditionCacheCoordinator.Cache var1);
}

