/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.cloud.PartitionEvent;
import org.rhq.core.domain.cloud.PartitionEventDetails;
import org.rhq.core.domain.cloud.PartitionEventType;
import org.rhq.core.domain.cloud.composite.FailoverListComposite;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.cloud.FailoverListManagerLocal;
import org.rhq.enterprise.server.cloud.PartitionEventManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.util.QueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class PartitionEventManagerBean
implements PartitionEventManagerLocal {
    private final Log LOG = LogFactory.getLog(PartitionEventManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    AgentManagerLocal agentManager;
    @EJB
    FailoverListManagerLocal failoverListManager;
    @EJB
    @IgnoreDependency
    PartitionEventManagerLocal partitionEventManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public FailoverListComposite agentPartitionEvent(Subject subject, String agentName, PartitionEventType eventType, String eventDetail) {
        if (eventType.isCloudPartitionEvent() || null == agentName) {
            throw new IllegalArgumentException("Invalid agent partition event or no agent specified for event type: " + eventType);
        }
        Agent agent = this.agentManager.getAgentByName(agentName);
        if (null == agent) {
            throw new IllegalArgumentException("Can not perform partition event, agent not found with name: " + agentName);
        }
        PartitionEvent partitionEvent = new PartitionEvent(subject.getName(), eventType, eventDetail, PartitionEvent.ExecutionStatus.IMMEDIATE);
        this.partitionEventManager.createPartitionEvent(subject, partitionEvent);
        return this.failoverListManager.getForSingleAgent(partitionEvent, agent.getName());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void createPartitionEvent(Subject subject, PartitionEvent partitionEvent) {
        this.entityManager.persist((Object)partitionEvent);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Map<Agent, FailoverListComposite> cloudPartitionEvent(Subject subject, PartitionEventType eventType, String eventDetail) {
        if (!eventType.isCloudPartitionEvent()) {
            throw new IllegalArgumentException("Invalid cloud partition event type: " + eventType);
        }
        PartitionEvent partitionEvent = new PartitionEvent(subject.getName(), eventType, eventDetail, PartitionEvent.ExecutionStatus.IMMEDIATE);
        this.entityManager.persist((Object)partitionEvent);
        return this.failoverListManager.refresh(partitionEvent);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void cloudPartitionEventRequest(Subject subject, PartitionEventType eventType, String eventDetail) {
        if (!eventType.isCloudPartitionEvent()) {
            throw new IllegalArgumentException("Invalid cloud partition event type: " + eventType);
        }
        PartitionEvent partitionEvent = new PartitionEvent(subject.getName(), eventType, eventDetail, PartitionEvent.ExecutionStatus.REQUESTED);
        this.entityManager.persist((Object)partitionEvent);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void auditPartitionEvent(Subject subject, PartitionEventType eventType, String eventDetail) {
        PartitionEvent partitionEvent = new PartitionEvent(subject.getName(), eventType, eventDetail, PartitionEvent.ExecutionStatus.AUDIT);
        this.entityManager.persist((Object)partitionEvent);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deletePartitionEvents(Subject subject, Integer[] partitionEventIds) {
        Integer[] arr$ = partitionEventIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int partitionEventId = arr$[i$];
            PartitionEvent doomedEvent = (PartitionEvent)this.entityManager.find(PartitionEvent.class, (Object)partitionEventId);
            this.entityManager.remove((Object)doomedEvent);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public int purgeAllEvents(Subject subject) {
        PageList<PartitionEvent> events = this.getPartitionEvents(subject, null, null, null, PageControl.getUnlimitedInstance());
        int i = 0;
        Integer[] eventIds = new Integer[events.size()];
        for (PartitionEvent event : events) {
            eventIds[i++] = event.getId();
        }
        this.deletePartitionEvents(subject, eventIds);
        return eventIds.length;
    }

    @Override
    public void processRequestedPartitionEvents() {
        boolean completedRequest = false;
        Query query = this.entityManager.createNamedQuery("PartitionEvent.findByExecutionStatus");
        query.setParameter("executionStatus", (Object)PartitionEvent.ExecutionStatus.REQUESTED);
        List requestedPartitionEvents = query.getResultList();
        for (PartitionEvent next : requestedPartitionEvents) {
            if (!completedRequest) {
                if (!next.getEventType().isCloudPartitionEvent()) {
                    this.LOG.warn((Object)("Invalid cloud partition event type: " + next.getEventType()));
                }
                try {
                    this.failoverListManager.refresh(next);
                    completedRequest = true;
                }
                catch (Exception e) {
                    this.LOG.warn((Object)("Failed requested partition event. Setting COMPLETED to avoid repeated failure: " + e));
                }
            }
            next.setExecutionStatus(PartitionEvent.ExecutionStatus.COMPLETED);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PartitionEvent getPartitionEvent(Subject subject, int partitionEventId) {
        PartitionEvent event = (PartitionEvent)this.entityManager.find(PartitionEvent.class, (Object)partitionEventId);
        return event;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PartitionEvent> getPartitionEvents(Subject subject, PartitionEventType type, PartitionEvent.ExecutionStatus status, String details, PageControl pageControl) {
        pageControl.initDefaultOrderingField("pe.ctime", PageOrdering.DESC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PartitionEvent.findAll", (PageControl)pageControl);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PartitionEvent.findAll");
        details = QueryUtility.formatSearchParameter(details);
        query.setParameter("type", (Object)type);
        countQuery.setParameter("type", (Object)type);
        query.setParameter("status", (Object)status);
        countQuery.setParameter("status", (Object)status);
        query.setParameter("details", (Object)details);
        countQuery.setParameter("details", (Object)details);
        query.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        countQuery.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PartitionEventDetails> getPartitionEventDetails(Subject subject, int partitionEventId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("ped.id", PageOrdering.ASC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PartitionEventDetails.findByEventId", (PageControl)pageControl);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PartitionEventDetails.findByEventId");
        query.setParameter("eventId", (Object)partitionEventId);
        countQuery.setParameter("eventId", (Object)partitionEventId);
        List detailsList = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)detailsList, (int)count, pageControl);
    }
}

