/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.bundle;

import java.io.File;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.enterprise.server.bundle.BundleDistributionInfo;
import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginFacet;
import org.rhq.enterprise.server.plugin.pc.bundle.UnknownRecipeException;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.bundle.BundlePluginDescriptorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.bundle.BundleType;

public class BundleServerPluginManager
extends ServerPluginManager {
    public BundleServerPluginManager(BundleServerPluginContainer pc) {
        super(pc);
    }

    public void initialize() throws Exception {
        super.initialize();
    }

    protected void loadPlugin(ServerPluginEnvironment env, boolean enabled) throws Exception {
        if (enabled) {
            BundlePluginDescriptorType descriptor = (BundlePluginDescriptorType)env.getPluginDescriptor();
            BundleType bt = descriptor.getBundle();
            if (bt == null || bt.getType() == null || bt.getType().length() == 0) {
                throw new Exception("The bundle plugin [" + env.getPluginKey().getPluginName() + "] did not specify a valid bundle type in its descriptor");
            }
            ServerPluginComponent component = this.createServerPluginComponent(env);
            if (!(component instanceof BundleServerPluginFacet)) {
                throw new Exception("The bundle plugin [" + env.getPluginKey().getPluginName() + "] has an invalid component [" + component + "]. It does not implement [" + BundleServerPluginFacet.class + "]");
            }
        }
        super.loadPlugin(env, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeParseResults parseRecipe(String bundleTypeName, String recipe) throws Exception {
        if (bundleTypeName == null) {
            throw new IllegalArgumentException("bundleTypeName == null");
        }
        if (recipe == null) {
            throw new IllegalArgumentException("recipe == null");
        }
        ServerPluginEnvironment pluginEnv = null;
        for (ServerPluginEnvironment env : this.getPluginEnvironments()) {
            BundlePluginDescriptorType descriptor = (BundlePluginDescriptorType)env.getPluginDescriptor();
            if (!bundleTypeName.equals(descriptor.getBundle().getType())) continue;
            pluginEnv = env;
            break;
        }
        if (pluginEnv == null) {
            throw new IllegalArgumentException("Bundle type [" + bundleTypeName + "] is not known to the system");
        }
        String pluginName = pluginEnv.getPluginKey().getPluginName();
        ServerPluginComponent component = this.getServerPluginComponent(pluginName);
        BundleServerPluginFacet facet = (BundleServerPluginFacet)((Object)component);
        this.getLog().debug((Object)("Bundle server plugin [" + pluginName + "] is parsing a bundle recipe"));
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginEnv.getPluginClassLoader());
            RecipeParseResults results = facet.parseRecipe(recipe);
            this.ensureDisplayNameIsSet(results);
            RecipeParseResults recipeParseResults = results;
            return recipeParseResults;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleDistributionInfo parseRecipe(String recipe) throws Exception {
        if (recipe == null) {
            throw new IllegalArgumentException("recipe == null");
        }
        BundleDistributionInfo info = null;
        for (ServerPluginEnvironment env : this.getPluginEnvironments()) {
            BundlePluginDescriptorType descriptor = (BundlePluginDescriptorType)env.getPluginDescriptor();
            String pluginName = env.getPluginKey().getPluginName();
            ServerPluginComponent component = this.getServerPluginComponent(pluginName);
            BundleServerPluginFacet facet = (BundleServerPluginFacet)((Object)component);
            this.getLog().debug((Object)("Bundle server plugin [" + pluginName + "] is parsing a recipe"));
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(env.getPluginClassLoader());
            try {
                RecipeParseResults results = facet.parseRecipe(recipe);
                info = new BundleDistributionInfo(recipe, results, null);
                info.setBundleTypeName(descriptor.getBundle().getType());
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
                break;
            }
            catch (UnknownRecipeException ure) {
                try {
                    info = null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalContextClassLoader);
                }
            }
        }
        if (null == info) {
            throw new IllegalArgumentException("Invalid recipe not recognized by any deployed server bundle plugin.");
        }
        this.ensureDisplayNameIsSet(info.getRecipeParseResults());
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleDistributionInfo processBundleDistributionFile(File distributionFile) throws Exception {
        if (null == distributionFile) {
            throw new IllegalArgumentException("bundleDistributionFile == null");
        }
        BundleDistributionInfo info = null;
        for (ServerPluginEnvironment env : this.getPluginEnvironments()) {
            BundlePluginDescriptorType descriptor = (BundlePluginDescriptorType)env.getPluginDescriptor();
            String pluginName = env.getPluginKey().getPluginName();
            ServerPluginComponent component = this.getServerPluginComponent(pluginName);
            BundleServerPluginFacet facet = (BundleServerPluginFacet)((Object)component);
            this.getLog().debug((Object)("Bundle server plugin [" + pluginName + "] is parsing a distribution file [" + distributionFile + "]"));
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(env.getPluginClassLoader());
            try {
                info = facet.processBundleDistributionFile(distributionFile);
                info.setBundleTypeName(descriptor.getBundle().getType());
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
                break;
            }
            catch (UnknownRecipeException ure) {
                try {
                    info = null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalContextClassLoader);
                }
            }
        }
        if (null == info) {
            throw new IllegalArgumentException("Invalid bundle distribution file. BundleType/Recipe not recognized by any deployed server bundle plugin.");
        }
        this.ensureDisplayNameIsSet(info.getRecipeParseResults());
        return info;
    }

    private void ensureDisplayNameIsSet(RecipeParseResults recipeParseResults) {
        if (recipeParseResults != null && recipeParseResults.getConfigurationDefinition() != null) {
            ConfigurationDefinition configDef = recipeParseResults.getConfigurationDefinition();
            for (PropertyDefinition propDef : configDef.getPropertyDefinitions().values()) {
                if (!(propDef instanceof PropertyDefinitionSimple) || propDef.getDisplayName() != null) continue;
                propDef.setDisplayName(propDef.getName());
            }
        }
    }
}

