/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.assist;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.enterprise.server.search.assist.AbstractSearchAssistant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupSearchAssistant
extends AbstractSearchAssistant {
    private static final List<String> parameterizedContexts = Collections.emptyList();
    private static final List<String> simpleContexts = Collections.unmodifiableList(Arrays.asList("availability", "category", "type", "plugin", "name"));

    @Override
    public SearchSubsystem getSearchSubsystem() {
        return SearchSubsystem.GROUP;
    }

    @Override
    public String getPrimarySimpleContext() {
        return "name";
    }

    @Override
    public List<String> getSimpleContexts() {
        return simpleContexts;
    }

    @Override
    public List<String> getParameterizedContexts() {
        return parameterizedContexts;
    }

    @Override
    public List<String> getParameters(String context, String filter) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getValues(String context, String param, String filter) {
        filter = this.stripQuotes(filter);
        if (context.equals("availability")) {
            return this.filter(AvailabilityType.class, filter);
        }
        if (context.equals("category")) {
            return this.filter(ResourceCategory.class, filter);
        }
        if (context.equals("type")) {
            return this.execute("SELECT DISTINCT type.name   FROM ResourceType type " + this.add(" WHERE LOWER(type.name) LIKE '%" + filter.toLowerCase() + "%'", filter) + " ORDER BY type.name ");
        }
        if (context.equals("plugin")) {
            return this.execute("SELECT DISTINCT type.plugin   FROM ResourceType type " + this.add(" WHERE LOWER(type.plugin) LIKE '%" + filter.toLowerCase() + "%'", filter) + " ORDER BY type.plugin ");
        }
        if (context.equals("name")) {
            return this.execute("SELECT DISTINCT rg.name   FROM ResourceGroup rg " + this.add(" WHERE LOWER(rg.name) LIKE '%" + filter.toLowerCase() + "%'", filter) + " ORDER BY rg.name ");
        }
        return Collections.emptyList();
    }
}

