/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.translation;

import org.rhq.enterprise.server.search.translation.SearchTranslator;
import org.rhq.enterprise.server.search.translation.antlr.RHQLComparisonOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSearchTranslator
implements SearchTranslator {
    private String process(ValueFilter filter, String value) {
        if (filter == ValueFilter.STARTS_WITH) {
            return "'" + value + "%'";
        }
        if (filter == ValueFilter.ENDS_WITH) {
            return "'%" + value + "'";
        }
        if (filter == ValueFilter.INDEX_OF) {
            return "'%" + value + "%'";
        }
        if (filter == ValueFilter.EXACT_MATCH) {
            return "'" + value + "'";
        }
        throw new IllegalArgumentException("Unsupported ValueFilter: " + (Object)((Object)filter));
    }

    private String getJPQLForString(String fragment, RHQLComparisonOperator operator, String value, ValueFilter filter) {
        if (operator == RHQLComparisonOperator.EQUALS) {
            return this.lower(fragment) + " LIKE " + this.process(filter, value.toLowerCase());
        }
        if (operator == RHQLComparisonOperator.EQUALS_STRICT) {
            return fragment + " LIKE " + this.process(filter, value);
        }
        if (operator == RHQLComparisonOperator.NOT_EQUALS) {
            return this.lower(fragment) + " NOT LIKE " + this.process(filter, value.toLowerCase());
        }
        if (operator == RHQLComparisonOperator.NOT_EQUALS_STRICT) {
            return fragment + " NOT LIKE " + this.process(filter, value);
        }
        if (operator == RHQLComparisonOperator.NULL) {
            return fragment + " IS NULL";
        }
        if (operator == RHQLComparisonOperator.NOT_NULL) {
            return fragment + " IS NOT NULL";
        }
        throw new IllegalArgumentException("Unsupported operator " + (Object)((Object)operator));
    }

    protected String getJPQLForString(String fragment, RHQLComparisonOperator operator, String value) {
        int size = value.length();
        if (value.startsWith("^")) {
            if (value.endsWith("$")) {
                return this.getJPQLForString(fragment, operator, value.substring(1, size - 1), ValueFilter.EXACT_MATCH);
            }
            return this.getJPQLForString(fragment, operator, value.substring(1), ValueFilter.STARTS_WITH);
        }
        if (value.endsWith("$")) {
            return this.getJPQLForString(fragment, operator, value.substring(0, size - 1), ValueFilter.ENDS_WITH);
        }
        return this.getJPQLForString(fragment, operator, value, ValueFilter.INDEX_OF);
    }

    protected String getJPQLForEnum(String fragment, RHQLComparisonOperator operator, String value, Class<? extends Enum<?>> enumClass, boolean useOrdinal) {
        if (operator == RHQLComparisonOperator.NULL || operator == RHQLComparisonOperator.NOT_NULL) {
            return fragment + operator.getDefaultTranslation();
        }
        if (operator == RHQLComparisonOperator.EQUALS || operator == RHQLComparisonOperator.EQUALS_STRICT || operator == RHQLComparisonOperator.NOT_EQUALS || operator == RHQLComparisonOperator.NOT_EQUALS_STRICT) {
            return fragment + operator.getDefaultTranslation() + this.getEnum(enumClass, value, useOrdinal);
        }
        throw new IllegalArgumentException("Unsupported operator " + (Object)((Object)operator));
    }

    protected String getEnum(Class<? extends Enum<?>> enumClass, String value, boolean useOrdinal) {
        value = value.toLowerCase();
        for (Enum<?> nextEnum : enumClass.getEnumConstants()) {
            if (!nextEnum.name().toLowerCase().equals(value)) continue;
            if (useOrdinal) {
                return String.valueOf(nextEnum.ordinal());
            }
            return this.quote(nextEnum.name());
        }
        throw new IllegalArgumentException("No enum of type '" + enumClass.getSimpleName() + "' with name matching '" + value + "'");
    }

    protected String lower(String data) {
        return "LOWER(" + data + ")";
    }

    protected String quote(String data) {
        return "'" + data + "'";
    }

    protected final String addFragmentIfParameterNotValue(String fragment, String parameter, String value) {
        if (!parameter.equalsIgnoreCase(value)) {
            return fragment;
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueFilter {
        STARTS_WITH,
        ENDS_WITH,
        INDEX_OF,
        EXACT_MATCH;

    }
}

