/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.test;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.rhq.core.clientapi.server.measurement.MeasurementServerService;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataPK;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.ResourceMeasurementScheduleRequest;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementServerServiceImpl;
import org.rhq.enterprise.server.test.MeasurementTestLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class MeasurementTestBean
implements MeasurementTestLocal {
    private static final String FAKE_PLATFORM_NAME = "Fake Platform";
    @PersistenceContext(unitName="rhqpu")
    EntityManager entityManager;
    private MeasurementServerService measurementServerService = new MeasurementServerServiceImpl();
    @EJB
    private MeasurementScheduleManagerLocal measurementScheduleManager;

    public void sendTestMeasurementReport() {
        Resource res = this.setupFakePlatformIfNeeded();
        int[] resourceIds = new int[]{res.getId()};
        Set<ResourceMeasurementScheduleRequest> scheds = this.measurementScheduleManager.findSchedulesForResourceAndItsDescendants(resourceIds, false);
        Date now = new Date();
        MeasurementReport report = new MeasurementReport();
        for (ResourceMeasurementScheduleRequest sched : scheds) {
            for (MeasurementScheduleRequest s : sched.getMeasurementSchedules()) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(now);
                for (int i = 0; i < 10; ++i) {
                    long dat = cal.getTimeInMillis();
                    MeasurementDataNumeric mdn = new MeasurementDataNumeric(new MeasurementDataPK(dat, s.getScheduleId()), Double.valueOf(i));
                    report.addData(mdn);
                    cal.add(13, -1);
                }
            }
        }
        this.measurementServerService.mergeMeasurementReport(report);
    }

    public void addProblemResource() {
        Resource res = this.setupFakePlatformIfNeeded();
        Availability ava = new Availability(res, new Date(), AvailabilityType.UP);
        this.entityManager.persist((Object)ava);
        if (res.getSchedules().size() == 0 && res.getResourceType().getMetricDefinitions().size() > 0) {
            MeasurementDefinition def = (MeasurementDefinition)res.getResourceType().getMetricDefinitions().iterator().next();
            MeasurementSchedule schedule = new MeasurementSchedule(def, res);
            this.entityManager.persist((Object)schedule);
            res.addSchedule(schedule);
        }
        this.entityManager.flush();
    }

    private Resource setupFakePlatformIfNeeded() {
        Resource res;
        try {
            Query q = this.entityManager.createQuery("SELECT res FROM Resource res WHERE res.name = :name");
            q.setParameter("name", (Object)FAKE_PLATFORM_NAME);
            res = (Resource)q.getSingleResult();
        }
        catch (NoResultException nre) {
            ResourceType resourceType = new ResourceType("fake platform", "", ResourceCategory.PLATFORM, null);
            resourceType.setPlugin("Platforms");
            this.entityManager.persist((Object)resourceType);
            MeasurementDefinition def = new MeasurementDefinition(resourceType, "Fake Definition");
            def.setUnits(MeasurementUnits.SECONDS);
            def.setResourceType(resourceType);
            this.entityManager.persist((Object)def);
            resourceType.addMetricDefinition(def);
            res = new Resource("org.jboss.on.TestPlatfor", FAKE_PLATFORM_NAME, resourceType);
            this.entityManager.persist((Object)res);
            this.entityManager.flush();
        }
        return res;
    }

    public void setAgentCurrentlyScheduledMetrics(double value) {
        String scheduleString = "SELECT schedule FROM MeasurementSchedule schedule WHERE schedule.definition.name = 'CurrentlyScheduleMeasurements' AND schedule.resource.name LIKE '%Agent%'";
        Query scheduleQuery = this.entityManager.createQuery(scheduleString);
        MeasurementSchedule schedule = (MeasurementSchedule)scheduleQuery.getSingleResult();
        MeasurementDataNumeric numericData = new MeasurementDataNumeric(new MeasurementDataPK(schedule.getId()), Double.valueOf(value));
        this.entityManager.persist((Object)numericData);
        LookupUtil.getAlertConditionCacheManager().checkConditions(new MeasurementData[]{numericData});
    }
}

