/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.annotations.IndexColumn;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceOperationHistoryCriteria;
import org.rhq.core.domain.criteria.SubjectCriteria;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.core.domain.tagging.Tag;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.search.execution.SearchTranslationManager;
import org.rhq.enterprise.server.util.QueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CriteriaQueryGenerator {
    private static final Log LOG = LogFactory.getLog(CriteriaQueryGenerator.class);
    private Criteria criteria;
    private String searchExpressionWhereClause;
    private String authorizationJoinFragment;
    private String authorizationPermsFragment;
    private String authorizationCustomConditionFragment;
    private int authorizationSubjectId;
    private String alias;
    private String className;
    private String projection;
    private String groupByClause;
    private String havingClause;
    private static String NL = System.getProperty("line.separator");
    private static List<String> EXPRESSION_START_KEYWORDS = new ArrayList<String>(2);
    private List<Field> persistentBagFields = new ArrayList<Field>();

    public CriteriaQueryGenerator(Criteria criteria) {
        this.criteria = criteria;
        this.className = criteria.getPersistentClass().getSimpleName();
        this.alias = this.criteria.getAlias();
        this.initializeJPQLFragmentFromSearchExpression();
    }

    public void setAuthorizationCustomConditionFragment(String fragment) {
        this.authorizationCustomConditionFragment = fragment;
    }

    public void setAuthorizationResourceFragment(AuthorizationTokenType type, int subjectId) {
        String defaultFragment = null;
        if (type == AuthorizationTokenType.RESOURCE) {
            defaultFragment = "resource";
        } else if (type == AuthorizationTokenType.GROUP) {
            defaultFragment = "group";
        }
        this.setAuthorizationResourceFragment(type, defaultFragment, subjectId);
    }

    private String fixFilterOverride(String expression, String fieldName) {
        boolean wantCaseInsensitiveMatch;
        boolean fuzzyMatch = expression.toLowerCase().contains(" like ") && !expression.toLowerCase().contains("select");
        boolean bl = wantCaseInsensitiveMatch = !this.criteria.isCaseSensitive() && fuzzyMatch;
        while (expression.indexOf(63) != -1) {
            String replacement = ":" + fieldName;
            expression = expression.replaceFirst("\\?", replacement);
        }
        if (!this.expressionStartsWithKeyword(expression)) {
            if (wantCaseInsensitiveMatch) {
                int indexOfFirstSpace = expression.indexOf(" ");
                String filterToken = expression.substring(0, indexOfFirstSpace);
                expression = "LOWER( " + this.alias + "." + filterToken + " ) " + expression.substring(indexOfFirstSpace);
            } else {
                expression = this.alias + "." + expression;
            }
        }
        if (fuzzyMatch) {
            expression = expression + QueryUtility.getEscapeClause();
        }
        return expression;
    }

    private boolean expressionStartsWithKeyword(String expression) {
        expression = expression.trim();
        int i = expression.trim().indexOf(" ");
        String startToken = expression.substring(0, i);
        return EXPRESSION_START_KEYWORDS.contains(startToken.toUpperCase());
    }

    public void setAuthorizationResourceFragment(AuthorizationTokenType type, String fragment, int subjectId) {
        this.authorizationSubjectId = subjectId;
        if (type == AuthorizationTokenType.RESOURCE) {
            this.authorizationJoinFragment = fragment == null ? "JOIN " + this.alias + ".implicitGroups authGroup " + NL + "JOIN authGroup.roles authRole " + NL + "JOIN authRole.subjects authSubject " + NL : "JOIN " + this.alias + "." + fragment + " authRes " + NL + "JOIN authRes.implicitGroups authGroup " + NL + "JOIN authGroup.roles authRole " + NL + "JOIN authRole.subjects authSubject " + NL;
        } else if (type == AuthorizationTokenType.GROUP) {
            this.authorizationJoinFragment = fragment == null ? "JOIN " + this.alias + ".roles authRole " + NL + "JOIN authRole.subjects authSubject " + NL : "JOIN " + this.alias + "." + fragment + " authGroup " + NL + "JOIN authGroup.roles authRole " + NL + "JOIN authRole.subjects authSubject " + NL;
        } else {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not yet support generating queries for '" + (Object)((Object)type) + "' token types");
        }
        List requiredPerms = this.criteria.getRequiredPermissions();
        if (null != requiredPerms && !requiredPerms.isEmpty()) {
            this.authorizationPermsFragment = "AND ( SELECT COUNT(DISTINCT p)" + NL + "      FROM Subject innerSubject" + NL + "      JOIN innerSubject.roles r" + NL + "      JOIN r.permissions p" + NL + "      WHERE innerSubject.id = " + this.authorizationSubjectId + NL + "      AND p IN ( :requiredPerms ) ) = :requiredPermsSize" + NL;
        }
    }

    public String getQueryString(boolean countQuery) {
        Map<String, Object> filterFields;
        StringBuilder results = new StringBuilder();
        results.append("SELECT ");
        if (countQuery) {
            results.append("COUNT(").append(this.alias).append(")").append(NL);
        } else if (this.projection == null) {
            results.append(this.alias).append(NL);
        } else {
            results.append(this.projection).append(NL);
        }
        results.append("FROM ").append(this.className).append(' ').append(this.alias).append(NL);
        if (!countQuery) {
            for (String fetchJoin : this.getFetchFields(this.criteria)) {
                if (this.isPersistentBag(fetchJoin)) {
                    this.addPersistentBag(fetchJoin);
                    continue;
                }
                results.append("LEFT JOIN FETCH ").append(this.alias).append('.').append(fetchJoin).append(NL);
            }
        }
        if (this.authorizationJoinFragment != null) {
            results.append(this.authorizationJoinFragment);
        }
        if ((filterFields = this.getFilterFields(this.criteria)).size() > 0 || this.authorizationJoinFragment != null || this.searchExpressionWhereClause != null) {
            results.append("WHERE ");
        }
        String conjunctiveFragment = this.criteria.isFiltersOptional() ? "OR " : "AND ";
        boolean wantCaseInsensitiveMatch = !this.criteria.isCaseSensitive();
        StringBuilder conjunctiveResults = new StringBuilder();
        boolean firstCrit = true;
        for (Map.Entry<String, Object> filterField : filterFields.entrySet()) {
            if (firstCrit) {
                firstCrit = false;
            } else {
                conjunctiveResults.append(NL).append(conjunctiveFragment);
            }
            String fieldName = filterField.getKey();
            String override = this.criteria.getJPQLFilterOverride(fieldName);
            String fragment = null;
            if (override != null) {
                fragment = this.fixFilterOverride(override, fieldName);
            } else {
                String operator = "=";
                if (filterField.getValue() instanceof String) {
                    operator = "like";
                    fragment = wantCaseInsensitiveMatch ? "LOWER( " + this.alias + "." + fieldName + " ) " + operator + " :" + fieldName : this.alias + "." + fieldName + " " + operator + " :" + fieldName;
                    fragment = fragment + QueryUtility.getEscapeClause();
                } else {
                    fragment = this.alias + "." + fieldName + " " + operator + " :" + fieldName;
                }
            }
            conjunctiveResults.append(fragment).append(' ');
        }
        if (conjunctiveResults.length() > 0) {
            results.append("( ").append((CharSequence)conjunctiveResults).append(")");
        }
        if (this.authorizationJoinFragment != null) {
            if (firstCrit) {
                firstCrit = false;
            } else {
                results.append(NL).append(" AND ");
            }
            results.append("authSubject.id = " + this.authorizationSubjectId + " ");
            if (null != this.authorizationPermsFragment) {
                results.append(this.authorizationPermsFragment + " ");
            }
        }
        if (this.authorizationCustomConditionFragment != null) {
            if (firstCrit) {
                firstCrit = false;
            } else {
                results.append(NL).append(" AND ");
            }
            results.append(this.authorizationCustomConditionFragment);
        }
        if (this.searchExpressionWhereClause != null) {
            if (firstCrit) {
                firstCrit = false;
            } else {
                results.append(NL).append(" AND ");
            }
            results.append(this.searchExpressionWhereClause);
        }
        if (!countQuery) {
            if (this.groupByClause != null) {
                results.append(NL).append("GROUP BY ").append(this.groupByClause);
            }
            if (this.havingClause != null) {
                results.append(NL).append("HAVING ").append(this.havingClause);
            }
            boolean overridden = true;
            PageControl pc = this.criteria.getPageControlOverrides();
            if (pc == null) {
                overridden = false;
                pc = CriteriaQueryGenerator.getPageControl(this.criteria);
            }
            boolean first = true;
            for (OrderingField orderingField : pc.getOrderingFields()) {
                if (first) {
                    results.append(NL).append("ORDER BY ");
                    first = false;
                } else {
                    results.append(", ");
                }
                String fieldName = orderingField.getField();
                String override = this.criteria.getJPQLSortOverride(fieldName);
                String suffix = override == null ? fieldName : override;
                String sortFragment = this.isNumber(suffix) ? suffix : this.alias + "." + suffix;
                PageOrdering ordering = orderingField.getOrdering();
                results.append(sortFragment).append(' ').append(ordering);
            }
        }
        results.append(NL);
        LOG.debug((Object)results);
        return results.toString();
    }

    private boolean isNumber(String input) {
        if (input == null) {
            return false;
        }
        for (char next : input.toCharArray()) {
            if (Character.isDigit(next)) continue;
            return false;
        }
        return true;
    }

    public List<String> getFetchFields(Criteria criteria) {
        ArrayList<String> results = new ArrayList<String>();
        for (Field fetchField : CriteriaQueryGenerator.getFields(criteria, Criteria.Type.FETCH)) {
            boolean shouldFetch;
            Object fetchFieldValue = null;
            try {
                fetchField.setAccessible(true);
                fetchFieldValue = fetchField.get(criteria);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            if (fetchFieldValue == null || !(shouldFetch = ((Boolean)fetchFieldValue).booleanValue())) continue;
            results.add(CriteriaQueryGenerator.getCleansedFieldName(fetchField, 5));
        }
        return results;
    }

    private static List<Field> getFields(Criteria criteria, Criteria.Type fieldType) {
        String prefix = fieldType.name().toLowerCase();
        ArrayList<Field> results = new ArrayList<Field>();
        Class<?> currentLevelClass = criteria.getClass();
        while (!currentLevelClass.equals(Criteria.class)) {
            for (Field field : currentLevelClass.getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.getName().startsWith(prefix)) continue;
                results.add(field);
            }
            currentLevelClass = currentLevelClass.getSuperclass();
        }
        return results;
    }

    public static String getCleansedFieldName(Field field, int leadingCharsToStrip) {
        String fieldNameFragment = field.getName().substring(leadingCharsToStrip);
        String fieldName = Character.toLowerCase(fieldNameFragment.charAt(0)) + fieldNameFragment.substring(1);
        return fieldName;
    }

    public Map<String, Object> getFilterFields(Criteria criteria) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Field filterField : CriteriaQueryGenerator.getFields(criteria, Criteria.Type.FILTER)) {
            Object filterFieldValue = null;
            try {
                filterFieldValue = filterField.get(criteria);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            if (filterFieldValue == null) continue;
            results.put(CriteriaQueryGenerator.getCleansedFieldName(filterField, 6), filterFieldValue);
        }
        return results;
    }

    private void initializeJPQLFragmentFromSearchExpression() {
        String searchExpression = this.criteria.getSearchExpression();
        if (searchExpression == null) {
            return;
        }
        try {
            Class entityClass = this.criteria.getPersistentClass();
            SearchTranslationManager searchManager = new SearchTranslationManager(SearchSubsystem.get((Class)entityClass));
            searchManager.setExpression(searchExpression);
            String translatedJPQL = searchManager.getJPQLWhereFragment();
            LOG.debug((Object)("Translated JPQL Fragment was: " + translatedJPQL));
            if (translatedJPQL != null) {
                this.searchExpressionWhereClause = translatedJPQL;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Could not get JPQL translation for '" + searchExpression + "': " + ThrowableUtil.getAllMessages((Throwable)e, (boolean)true)));
        }
    }

    private boolean isPersistentBag(String fieldName) {
        try {
            Class persistentClass = this.criteria.getPersistentClass();
            Field field = persistentClass.getDeclaredField(fieldName);
            return this.isAList(field) && !field.isAnnotationPresent(IndexColumn.class);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private boolean isAList(Field field) {
        Class<?> fieldType = field.getType();
        if (List.class.isAssignableFrom(fieldType)) {
            return true;
        }
        for (Class<?> declaredInterface : fieldType.getInterfaces()) {
            if (!List.class.isAssignableFrom(declaredInterface)) continue;
            return true;
        }
        return false;
    }

    private void addPersistentBag(String fieldName) {
        try {
            Field field = this.criteria.getPersistentClass().getDeclaredField(fieldName);
            this.persistentBagFields.add(field);
        }
        catch (NoSuchFieldException e) {
            LOG.warn((Object)"Failed to add persistent bag collection.", (Throwable)e);
        }
    }

    public List<Field> getPersistentBagFields() {
        return this.persistentBagFields;
    }

    public void alterProjection(String projection) {
        this.projection = projection;
    }

    public void setGroupByClause(String groupByClause) {
        if (groupByClause != null && this.projection == null) {
            throw new IllegalArgumentException("Must alter projection before calling setGroupByClause");
        }
        this.groupByClause = groupByClause;
    }

    public void setHavingClause(String havingClause) {
        if (havingClause != null && this.groupByClause == null) {
            throw new IllegalArgumentException("Must add some groupBy clause before calling setHavingClause");
        }
        this.havingClause = havingClause;
    }

    public Query getQuery(EntityManager em) {
        String queryString = this.getQueryString(false);
        Query query = em.createQuery(queryString);
        this.setBindValues(query, false);
        PersistenceUtility.setDataPage((Query)query, (PageControl)CriteriaQueryGenerator.getPageControl(this.criteria));
        return query;
    }

    public Query getCountQuery(EntityManager em) {
        String countQueryString = this.getQueryString(true);
        Query query = em.createQuery(countQueryString);
        this.setBindValues(query, false);
        return query;
    }

    private void setBindValues(Query query, boolean countQuery) {
        for (Map.Entry<String, Object> critField : this.getFilterFields(this.criteria).entrySet()) {
            Object value = critField.getValue();
            if (value instanceof Tag) {
                Tag tag = (Tag)value;
                query.setParameter("tagNamespace", (Object)tag.getNamespace());
                query.setParameter("tagSemantic", (Object)tag.getSemantic());
                query.setParameter("tagName", (Object)tag.getName());
                continue;
            }
            if (value instanceof String) {
                value = this.prepareStringBindValue((String)value);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Bind: (" + critField.getKey() + ", " + value + ")"));
            }
            query.setParameter(critField.getKey(), value);
        }
        if (null != this.authorizationPermsFragment) {
            List requiredPerms = this.criteria.getRequiredPermissions();
            query.setParameter("requiredPerms", (Object)requiredPerms);
            query.setParameter("requiredPermsSize", (Object)requiredPerms.size());
        }
    }

    private String prepareStringBindValue(String value) {
        if (!this.criteria.isStrict()) {
            value = "%" + QueryUtility.escapeSearchParameter(value) + "%";
        }
        if (!this.criteria.isCaseSensitive()) {
            value = value.toLowerCase();
        }
        return value;
    }

    public static void main(String[] args) {
        CriteriaQueryGenerator.testResourceCriteria();
    }

    public static void testSubjectCriteria() {
        SubjectCriteria subjectCriteria = new SubjectCriteria();
        subjectCriteria.addFilterFirstName("joe");
        subjectCriteria.addFilterFactive(Boolean.valueOf(true));
        subjectCriteria.fetchRoles(true);
        subjectCriteria.addSortName(PageOrdering.ASC);
        CriteriaQueryGenerator subjectGenerator = new CriteriaQueryGenerator((Criteria)subjectCriteria);
        System.out.println(subjectGenerator.getQueryString(false));
        System.out.println(subjectGenerator.getQueryString(true));
    }

    public static void testAlertCriteria() {
        AlertCriteria alertCriteria = new AlertCriteria();
        alertCriteria.addFilterName("joe");
        alertCriteria.addFilterDescription("query generation is cool");
        alertCriteria.addFilterStartTime(Long.valueOf(42L));
        alertCriteria.addFilterEndTime(Long.valueOf(100L));
        alertCriteria.addFilterResourceIds(new Integer[]{1, 2, 3});
        alertCriteria.fetchAlertDefinition(true);
        alertCriteria.addSortPriority(PageOrdering.DESC);
        alertCriteria.addSortName(PageOrdering.ASC);
        alertCriteria.setPaging(0, 100);
        alertCriteria.setFiltersOptional(true);
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)alertCriteria);
        System.out.println(generator.getQueryString(false));
        System.out.println(generator.getQueryString(true));
        generator.setAuthorizationResourceFragment(AuthorizationTokenType.RESOURCE, "definition.resource", 1);
        System.out.println(generator.getQueryString(false));
        System.out.println(generator.getQueryString(true));
    }

    public static void testInheritanceCriteria() {
        ResourceOperationHistoryCriteria historyCriteria = new ResourceOperationHistoryCriteria();
        historyCriteria.addFilterResourceIds(new Integer[]{1});
        historyCriteria.addFilterStatus(OperationRequestStatus.FAILURE);
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)historyCriteria);
        System.out.println(generator.getQueryString(false));
        System.out.println(generator.getQueryString(true));
    }

    public static void testResourceCriteria() {
        ResourceCriteria resourceCriteria = new ResourceCriteria();
        resourceCriteria.addFilterResourceCategory(ResourceCategory.SERVER);
        resourceCriteria.addFilterName("marques");
        resourceCriteria.fetchAgent(true);
        resourceCriteria.addSortResourceTypeName(PageOrdering.ASC);
        resourceCriteria.setCaseSensitive(true);
        resourceCriteria.setFiltersOptional(true);
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)resourceCriteria);
        generator.getQueryString(false);
        generator.getQueryString(true);
    }

    public static PageControl getPageControl(Criteria criteria) {
        PageControl pc = null;
        if (criteria.getPageControlOverrides() != null) {
            pc = criteria.getPageControlOverrides();
        } else {
            pc = criteria.getPageNumber() == null || criteria.getPageSize() == null ? PageControl.getUnlimitedInstance() : new PageControl(criteria.getPageNumber().intValue(), criteria.getPageSize().intValue());
            for (String fieldName : criteria.getOrderingFieldNames()) {
                for (Field sortField : CriteriaQueryGenerator.getFields(criteria, Criteria.Type.SORT)) {
                    if (!sortField.getName().equals(fieldName)) continue;
                    Object sortFieldValue = null;
                    try {
                        sortFieldValue = sortField.get(criteria);
                    }
                    catch (IllegalAccessException iae) {
                        throw new RuntimeException(iae);
                    }
                    if (sortFieldValue == null) continue;
                    PageOrdering pageOrdering = (PageOrdering)sortFieldValue;
                    pc.addDefaultOrderingField(CriteriaQueryGenerator.getCleansedFieldName(sortField, 4), pageOrdering);
                }
            }
        }
        return pc;
    }

    static {
        EXPRESSION_START_KEYWORDS.add("NOT");
        EXPRESSION_START_KEYWORDS.add("EXISTS");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthorizationTokenType {
        RESOURCE,
        GROUP;

    }
}

