/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.cts.ejb;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.test.cts.interfaces.CalleeData;
import org.jboss.test.cts.interfaces.CalleeException;
import org.jboss.test.cts.interfaces.CallerSession;
import org.jboss.test.cts.interfaces.CallerSessionHome;
import org.jboss.test.cts.interfaces.ReferenceTest;
import org.jboss.test.util.ejb.SessionSupport;
import org.jboss.util.Classes;

public class CallerSessionBean
extends SessionSupport {
    private static Logger log = Logger.getLogger(CallerSessionBean.class);
    private CallerSessionHome cachedHome;

    public void ejbCreate() throws CreateException {
    }

    public CalleeData simpleCall2(boolean isCaller) throws RemoteException {
        StringBuffer info = new StringBuffer("simpleCall2, isCaller: " + isCaller);
        info.append(" CalleeData, ");
        try {
            Classes.displayClassInfo(CalleeData.class, (StringBuffer)info);
            log.info((Object)info.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!isCaller) {
            return new CalleeData();
        }
        CallerSessionHome home = null;
        CallerSession callee = null;
        try {
            home = this.lookupHome("ejbcts2/CalleeSessionHome");
            callee = home.create();
        }
        catch (NamingException e) {
            throw new ServerException("Failed to lookup CalleeHome", e);
        }
        catch (CreateException e) {
            throw new ServerException("Failed to create Callee", (Exception)((Object)e));
        }
        CalleeData data = callee.simpleCall(false);
        return data;
    }

    public CalleeData simpleCall(boolean isCaller) throws RemoteException {
        StringBuffer info = new StringBuffer("simpleCall, isCaller: " + isCaller);
        info.append(" CalleeData, ");
        try {
            Classes.displayClassInfo(CalleeData.class, (StringBuffer)info);
            log.info((Object)info.toString());
        }
        catch (Exception e) {
            log.debug((Object)"displayClassInfo failure", (Throwable)e);
        }
        if (!isCaller) {
            return new CalleeData();
        }
        CallerSession callee = null;
        try {
            this.cachedHome = this.lookupHome("ejbcts2/CalleeSessionHome");
            callee = this.cachedHome.create();
        }
        catch (NamingException e) {
            throw new ServerException("Failed to lookup CalleeHome", e);
        }
        catch (CreateException e) {
            throw new ServerException("Failed to create Callee", (Exception)((Object)e));
        }
        catch (Throwable e) {
            log.error((Object)"Unexpected error", e);
            throw new ServerException("Unexpected error" + e.getMessage());
        }
        CalleeData data = callee.simpleCall2(false);
        return data;
    }

    public void callByValueInSameJar() throws RemoteException {
        CallerSession callee = null;
        try {
            this.cachedHome = this.lookupHome("ejbcts/CalleeSessionHome");
            callee = this.cachedHome.create();
        }
        catch (NamingException e) {
            throw new ServerException("Failed to lookup CalleeHome", e);
        }
        catch (CreateException e) {
            throw new ServerException("Failed to create Callee", (Exception)((Object)e));
        }
        catch (Throwable e) {
            log.error((Object)"Unexpected error", e);
            throw new ServerException("Unexpected error" + e.getMessage());
        }
        ReferenceTest test = new ReferenceTest();
        callee.validateValueMarshalling(test);
    }

    public void callAppEx() throws CalleeException, RemoteException {
        StringBuffer info = new StringBuffer("appEx, CalleeException, ");
        try {
            Classes.displayClassInfo(CalleeException.class, (StringBuffer)info);
            log.info((Object)info.toString());
        }
        catch (Exception e) {
            log.debug((Object)"displayClassInfo failure", (Throwable)e);
        }
        CallerSessionHome home = null;
        CallerSession callee = null;
        try {
            home = this.lookupHome("ejbcts2/CalleeSessionHome");
            callee = home.create();
            callee.appEx();
        }
        catch (NamingException e) {
            throw new ServerException("Failed to lookup CalleeHome", e);
        }
        catch (CreateException e) {
            throw new ServerException("Failed to create Callee", (Exception)((Object)e));
        }
        catch (CalleeException e) {
            throw e;
        }
    }

    public void appEx() throws CalleeException {
        StringBuffer info = new StringBuffer("appEx, CalleeException, ");
        try {
            Classes.displayClassInfo(CalleeException.class, (StringBuffer)info);
            log.info((Object)info.toString());
        }
        catch (Exception e) {
            log.debug((Object)"displayClassInfo failure", (Throwable)e);
        }
        throw new CalleeException();
    }

    public void validateValueMarshalling(ReferenceTest test) {
        boolean wasSerialized = test.getWasSerialized();
        log.info((Object)("validateValueMarshalling, testWasSerialized: " + wasSerialized));
        if (!wasSerialized) {
            throw new EJBException("ReferenceTest was not serialized");
        }
    }

    private CallerSessionHome lookupHome(String ejbName) throws NamingException {
        CallerSessionHome home = null;
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.setProperty("java.naming.factory.object", "org.jboss.naming:org.jnp.interfaces");
        env.setProperty("java.naming.provider.url", System.getProperty("jboss.bind.address", "localhost") + ":1099");
        InitialContext ctx = new InitialContext(env);
        log.info((Object)("looking up: " + ejbName));
        Object ref = ctx.lookup(ejbName);
        StringBuffer buffer = new StringBuffer("JNDI CallerSessionHome.class: ");
        try {
            Classes.displayClassInfo(ref.getClass(), (StringBuffer)buffer);
            log.info((Object)buffer.toString());
        }
        catch (Exception e) {
            log.debug((Object)"displayClassInfo failure", (Throwable)e);
        }
        buffer.setLength(0);
        buffer.append("Session CallerSessionHome.class: ");
        try {
            Classes.displayClassInfo(CallerSessionHome.class, (StringBuffer)buffer);
            log.info((Object)buffer.toString());
        }
        catch (Exception e) {
            log.debug((Object)"displayClassInfo failure", (Throwable)e);
        }
        home = (CallerSessionHome)ref;
        return home;
    }
}

