/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc;

import java.net.URL;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

public class ServerPluginEnvironment {
    private final URL pluginUrl;
    private final PluginKey pluginKey;
    private final ClassLoader pluginClassLoader;
    private final ServerPluginDescriptorType pluginDescriptor;

    public ServerPluginEnvironment(URL pluginUrl, ClassLoader classLoader, ServerPluginDescriptorType descriptor) throws Exception {
        this.pluginUrl = pluginUrl;
        this.pluginClassLoader = classLoader;
        this.pluginDescriptor = descriptor;
        String pluginTypeStr = new ServerPluginType(descriptor).stringify();
        this.pluginKey = PluginKey.createServerPluginKey((String)pluginTypeStr, (String)this.pluginDescriptor.getName());
    }

    public PluginKey getPluginKey() {
        return this.pluginKey;
    }

    public URL getPluginUrl() {
        return this.pluginUrl;
    }

    public ClassLoader getPluginClassLoader() {
        return this.pluginClassLoader;
    }

    public ServerPluginDescriptorType getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public String toString() {
        return this.pluginKey + ": url=[" + this.pluginUrl + "]";
    }
}

