/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import javax.servlet.ServletException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class SemaphoreValve
extends ValveBase
implements Lifecycle {
    private static final String info = "org.apache.catalina.valves.SemaphoreValve/1.0";
    private StringManager sm = StringManager.getManager("org.apache.catalina.valves");
    protected Semaphore semaphore = null;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private boolean started = false;
    protected int concurrency = 10;
    protected boolean fairness = false;
    protected boolean block = true;
    protected boolean interruptible = false;

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public boolean getFairness() {
        return this.fairness;
    }

    public void setFairness(boolean fairness) {
        this.fairness = fairness;
    }

    public boolean getBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public boolean getInterruptible() {
        return this.interruptible;
    }

    public void setInterruptible(boolean interruptible) {
        this.interruptible = interruptible;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("semaphoreValve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.semaphore = new Semaphore(this.concurrency, this.fairness);
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("semaphoreValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.semaphore = null;
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block14: {
            block13: {
                if (!this.controlConcurrency(request, response)) break block13;
                boolean shouldRelease = true;
                try {
                    if (this.block) {
                        if (this.interruptible) {
                            try {
                                this.semaphore.acquire();
                            }
                            catch (InterruptedException e) {
                                shouldRelease = false;
                                this.permitDenied(request, response);
                                Object var6_5 = null;
                                if (shouldRelease) {
                                    this.semaphore.release();
                                }
                                return;
                            }
                        } else {
                            this.semaphore.acquireUninterruptibly();
                        }
                    } else if (!this.semaphore.tryAcquire()) {
                        shouldRelease = false;
                        this.permitDenied(request, response);
                        Object var6_6 = null;
                        if (shouldRelease) {
                            this.semaphore.release();
                        }
                        return;
                    }
                    this.getNext().invoke(request, response);
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (shouldRelease) {
                        this.semaphore.release();
                    }
                    throw throwable;
                }
                Object var6_7 = null;
                if (shouldRelease) {
                    this.semaphore.release();
                }
                break block14;
            }
            this.getNext().invoke(request, response);
        }
    }

    public boolean controlConcurrency(Request request, Response response) {
        return true;
    }

    public void permitDenied(Request request, Response response) throws IOException, ServletException {
    }
}

