/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.cts.interfaces;

import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import org.jboss.logging.Logger;
import org.jboss.test.cts.interfaces.CtsBmp;
import org.jboss.test.cts.interfaces.CtsBmpHome;
import org.jboss.test.cts.keys.AccountPK;

public class UserTransactionTester {
    static Logger log = Logger.getLogger(UserTransactionTester.class);
    private CtsBmpHome home;
    private UserTransaction ut;
    private CtsBmp bean1;
    private CtsBmp bean2;

    public UserTransactionTester(CtsBmpHome home, UserTransaction userTransaction) {
        this.home = home;
        this.ut = userTransaction;
    }

    public boolean runAllTests() {
        if (!this.testBeginRollback()) {
            return false;
        }
        if (!this.testBeginCommit()) {
            return false;
        }
        if (!this.testBeginSetrollbackonlyRollback()) {
            return false;
        }
        if (!this.testBeginSetrollbackonlyCommit()) {
            return false;
        }
        try {
            this.bean1 = this.home.create(new AccountPK("UT_TestBean1"), "Ole1");
        }
        catch (Exception ex) {
            log.debug((Object)"failed", (Throwable)ex);
            return false;
        }
        if (!this.testSingleRollback()) {
            return false;
        }
        if (!this.testSingleCommit()) {
            return false;
        }
        if (!this.testSingleSetrollbackonlyCommit()) {
            return false;
        }
        try {
            this.ut.begin();
            this.bean2 = this.home.create(new AccountPK("UT_TestBean2"), "Ole2");
            this.ut.rollback();
            boolean gotException = false;
            try {
                this.bean2.setPersonsName("Ole");
            }
            catch (Exception e) {
                log.info((Object)"IGNORE PREVIOUS NoSuchEntityException - it is intentional");
                gotException = true;
            }
            if (!gotException) {
                throw new RuntimeException("Rollback didn't rollback create.");
            }
        }
        catch (Exception ex) {
            log.debug((Object)"failed", (Throwable)ex);
            return false;
        }
        try {
            this.bean2 = this.home.create(new AccountPK("UT_TestBean2"), "Ole2");
        }
        catch (Exception ex) {
            log.debug((Object)"failed", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean testBeginRollback() {
        try {
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
            this.ut.begin();
            if (this.ut.getStatus() != 0) {
                throw new RuntimeException("New tx not active.");
            }
            this.ut.rollback();
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
        }
        catch (Exception ex) {
            log.debug((Object)"failed", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean testBeginCommit() {
        try {
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
            this.ut.begin();
            if (this.ut.getStatus() != 0) {
                throw new RuntimeException("New tx not active.");
            }
            this.ut.commit();
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
        }
        catch (Exception ex) {
            log.debug((Object)"failed", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean testBeginSetrollbackonlyRollback() {
        try {
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
            this.ut.begin();
            if (this.ut.getStatus() != 0) {
                throw new RuntimeException("New tx not active.");
            }
            this.ut.setRollbackOnly();
            if (this.ut.getStatus() != 1) {
                throw new RuntimeException("Tx not marked for rollback.");
            }
            this.ut.rollback();
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
        }
        catch (Exception ex) {
            log.debug((Object)"failed", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean testBeginSetrollbackonlyCommit() {
        try {
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
            this.ut.begin();
            if (this.ut.getStatus() != 0) {
                throw new RuntimeException("New tx not active.");
            }
            this.ut.setRollbackOnly();
            if (this.ut.getStatus() != 1) {
                throw new RuntimeException("Tx not marked for rollback.");
            }
            boolean gotException = false;
            try {
                this.ut.commit();
            }
            catch (RollbackException rbe) {
                gotException = true;
            }
            if (!gotException) {
                throw new RuntimeException("Didn't get expected RollbackException.");
            }
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
        }
        catch (Exception ex) {
            log.debug((Object)"failed", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean testSingleRollback() {
        try {
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
            this.bean1.setPersonsName("Ole");
            if (!this.bean1.getPersonsName().equals("Ole")) {
                throw new RuntimeException("Unable to set property.");
            }
            this.ut.begin();
            if (this.ut.getStatus() != 0) {
                throw new RuntimeException("New tx not active.");
            }
            if (!this.bean1.getPersonsName().equals("Ole")) {
                throw new RuntimeException("Property changes after begin.");
            }
            this.bean1.setPersonsName("Peter");
            if (!this.bean1.getPersonsName().equals("Peter")) {
                throw new RuntimeException("Unable to set property.");
            }
            this.ut.rollback();
            if (!this.bean1.getPersonsName().equals("Ole")) {
                throw new RuntimeException("Rollback doesn't work.");
            }
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
        }
        catch (Exception ex) {
            log.debug((Object)"failed", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean testSingleCommit() {
        try {
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
            this.bean1.setPersonsName("Ole");
            if (!this.bean1.getPersonsName().equals("Ole")) {
                throw new RuntimeException("Unable to set property.");
            }
            this.ut.begin();
            if (this.ut.getStatus() != 0) {
                throw new RuntimeException("New tx not active.");
            }
            if (!this.bean1.getPersonsName().equals("Ole")) {
                throw new RuntimeException("Property changes after begin.");
            }
            this.bean1.setPersonsName("Peter");
            if (!this.bean1.getPersonsName().equals("Peter")) {
                throw new RuntimeException("Unable to set property.");
            }
            this.ut.commit();
            if (!this.bean1.getPersonsName().equals("Peter")) {
                throw new RuntimeException("Property not set after commit.");
            }
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
        }
        catch (Exception ex) {
            log.debug((Object)"failed", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean testSingleSetrollbackonlyCommit() {
        try {
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
            this.bean1.setPersonsName("Ole");
            if (!this.bean1.getPersonsName().equals("Ole")) {
                throw new RuntimeException("Unable to set property.");
            }
            this.ut.begin();
            if (this.ut.getStatus() != 0) {
                throw new RuntimeException("New tx not active.");
            }
            if (!this.bean1.getPersonsName().equals("Ole")) {
                throw new RuntimeException("Property changes after begin.");
            }
            this.bean1.setPersonsName("Peter");
            if (!this.bean1.getPersonsName().equals("Peter")) {
                throw new RuntimeException("Unable to set property.");
            }
            this.ut.setRollbackOnly();
            if (this.ut.getStatus() != 1) {
                throw new RuntimeException("Tx not marked for rollback.");
            }
            boolean gotException = false;
            try {
                this.ut.commit();
            }
            catch (RollbackException rbe) {
                gotException = true;
            }
            if (!gotException) {
                throw new RuntimeException("Didn't get expected RollbackException.");
            }
            if (!this.bean1.getPersonsName().equals("Ole")) {
                throw new RuntimeException("Didn't roll back.");
            }
            if (this.ut.getStatus() != 6) {
                throw new RuntimeException("No tx should be active.");
            }
        }
        catch (Exception ex) {
            log.debug((Object)"failed", (Throwable)ex);
            return false;
        }
        return true;
    }
}

