/*
 * RHQ Management Platform
 * Copyright (C) 2005-2012 Red Hat, Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.rhq.enterprise.server.rest.domain;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;

import com.wordnik.swagger.annotations.ApiClass;
import com.wordnik.swagger.annotations.ApiProperty;

/**
 * A group definition ("Dyna Group definition")
 * @author Heiko W. Rupp
 */
@ApiClass("One DynaGroup definition")
@XmlRootElement(name="groupDefinition")
public class GroupDefinitionRest {

    private int id;
    private String name;
    private String description;
    private List<String>  expression;
    private long recalcInterval;
    private boolean recursive=false;
    List<Integer> generatedGroupIds;
    List<Link> links = new ArrayList<Link>();

    public GroupDefinitionRest() {
    }

    public GroupDefinitionRest(int id, String name, String description, long recalcInterval) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.recalcInterval = recalcInterval;
    }

    @ApiProperty("The id of the definition")
    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @ApiProperty("The name of the definition")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiProperty("A description of the definition")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiProperty("Individual lines of the group expression")
    public List<String> getExpression() {
        return expression;
    }

    public void setExpression(List<String> expression) {
        this.expression = expression;
    }

    @ApiProperty("Interval in ms at which the expression should be re-evaluated. A value of 0 means no recalculation.")
    public long getRecalcInterval() {
        return recalcInterval;
    }

    public void setRecalcInterval(long recalcInterval) {
        this.recalcInterval = recalcInterval;
    }

    @ApiProperty("List of ids for the groups generated by this group expression")
    public List<Integer> getGeneratedGroupIds() {
        return generatedGroupIds;
    }

    public void setGeneratedGroupIds(List<Integer> generatedGroupIds) {
        this.generatedGroupIds = generatedGroupIds;
    }

    @ApiProperty("Is this definition generating rescursive groups?")
    public boolean isRecursive() {
        return recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public List<Link> getLinks() {
        return links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

}
