/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.entitlement;

import java.util.Collection;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.enterprise.server.entitlement.EntitlementManagerLocal;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginServiceManagement;
import org.rhq.enterprise.server.plugin.pc.entitlement.EntitlementServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.entitlement.EntitlementServerPluginManager;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class EntitlementManagerBean
implements EntitlementManagerLocal {
    private final Log log = LogFactory.getLog((String)EntitlementManagerBean.class.getName());
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    public void doSomething() {
        try {
            Collection<ServerPluginEnvironment> envs = this.getEntitlementServerPluginManager().getPluginEnvironments();
            for (ServerPluginEnvironment env : envs) {
                PluginKey pluginKey = env.getPluginKey();
                this.log.info((Object)("Deployed Entitlement plugin: " + pluginKey));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private EntitlementServerPluginManager getEntitlementServerPluginManager() throws Exception {
        EntitlementServerPluginManager pluginMgr = (EntitlementServerPluginManager)this.getEntitlementServerPluginContainer().getPluginManager();
        if (pluginMgr == null) {
            throw new Exception("Entitlement server plugin manager does not exist");
        }
        return pluginMgr;
    }

    private EntitlementServerPluginContainer getEntitlementServerPluginContainer() throws Exception {
        MasterServerPluginContainer master = this.getMasterServerPluginContainer();
        EntitlementServerPluginContainer pc = master.getPluginContainerByClass(EntitlementServerPluginContainer.class);
        if (pc == null) {
            throw new Exception("Entitlement server plugin container does not exist");
        }
        return pc;
    }

    private MasterServerPluginContainer getMasterServerPluginContainer() throws Exception {
        ServerPluginServiceManagement serverPluginService = LookupUtil.getServerPluginService();
        MasterServerPluginContainer master = serverPluginService.getMasterPluginContainer();
        if (master == null) {
            throw new Exception("Master plugin container has not be started");
        }
        return master;
    }
}

