/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective.activator;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.core.domain.authz.Permission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceConditionSet {
    static final long serialVersionUID = 1L;
    private String pluginName;
    private String resourceTypeName;
    private EnumSet<Permission> permissions;
    private Map<String, Pattern> traits;
    private Map<String, Matcher> traitMatchers;

    public ResourceConditionSet(String pluginName, String resourceTypeName, EnumSet<Permission> permissions, Map<String, Pattern> traits) {
        this.pluginName = pluginName;
        this.resourceTypeName = resourceTypeName;
        EnumSet<Permission> enumSet = this.permissions = permissions != null ? permissions : EnumSet.noneOf(Permission.class);
        if (null != traits) {
            this.traits = traits;
            this.traitMatchers = new HashMap<String, Matcher>(traits.size());
            for (String trait : traits.keySet()) {
                this.traitMatchers.put(trait, traits.get(trait).matcher(""));
            }
        } else {
            this.traits = Collections.emptyMap();
            this.traitMatchers = Collections.emptyMap();
        }
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    public EnumSet<Permission> getPermissions() {
        return this.permissions;
    }

    public Map<String, Pattern> getTraits() {
        return this.traits;
    }

    public Map<String, Matcher> getTraitMatchers() {
        return this.traitMatchers;
    }
}

