/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.disambiguation;

import java.util.ArrayList;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationUpdateStrategy;
import org.rhq.enterprise.server.resource.disambiguation.MutableDisambiguationReport;
import org.rhq.enterprise.server.resource.disambiguation.ResourceResolution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisambiguationPolicy
extends ArrayList<ResourceResolution> {
    private static final long serialVersionUID = 1L;
    private DisambiguationUpdateStrategy parentsUpdateStrategy;

    public DisambiguationPolicy(DisambiguationUpdateStrategy parentsDisambiguationStrategy) {
        this.parentsUpdateStrategy = parentsDisambiguationStrategy;
    }

    public DisambiguationPolicy(DisambiguationPolicy other) {
        super(other);
        this.parentsUpdateStrategy = other.parentsUpdateStrategy;
    }

    public static DisambiguationPolicy getUniqueNamePolicy(DisambiguationUpdateStrategy parentsDisambiguationStrategy) {
        DisambiguationPolicy ret = new DisambiguationPolicy(parentsDisambiguationStrategy);
        ret.add(ResourceResolution.NAME);
        return ret;
    }

    public DisambiguationUpdateStrategy getParentsUpdateStrategy() {
        return this.parentsUpdateStrategy;
    }

    public void setParentsUpdateStrategy(DisambiguationUpdateStrategy parentsUpdateStrategy) {
        this.parentsUpdateStrategy = parentsUpdateStrategy;
    }

    public <T> boolean areAmbiguous(MutableDisambiguationReport<T> a, MutableDisambiguationReport<T> b) {
        MutableDisambiguationReport.Resource ra = this.getComparingResource(a);
        MutableDisambiguationReport.Resource rb = this.getComparingResource(b);
        if (ra == null || rb == null) {
            return false;
        }
        ResourceResolution resolution = (ResourceResolution)((Object)this.get(this.size() - 1));
        return resolution.areAmbiguous(ra, rb);
    }

    public ResourceResolution getCurrentResourceResolution() {
        return this.size() > 0 ? (ResourceResolution)((Object)this.get(this.size() - 1)) : null;
    }

    public DisambiguationPolicy getNext() {
        int lastIdx = this.size() - 1;
        ResourceResolution lastResolution = (ResourceResolution)((Object)this.get(lastIdx));
        DisambiguationPolicy ret = new DisambiguationPolicy(this);
        switch (lastResolution) {
            case NAME: {
                ret.set(lastIdx, ResourceResolution.TYPE);
                break;
            }
            case TYPE: {
                ret.set(lastIdx, ResourceResolution.PLUGIN);
                break;
            }
            case PLUGIN: {
                ret.add(ResourceResolution.NAME);
            }
        }
        return ret;
    }

    public DisambiguationPolicy getNextRepartitioningPolicy() {
        ResourceResolution currentResolution = (ResourceResolution)((Object)this.get(this.size() - 1));
        if (this.parentsUpdateStrategy.alwaysRepartitionableResolutions().contains((Object)currentResolution) || this.size() == 1 && this.parentsUpdateStrategy.resourceLevelRepartitionableResolutions().contains((Object)currentResolution)) {
            DisambiguationPolicy newPolicy = this.getNext();
            if (currentResolution == ResourceResolution.TYPE) {
                newPolicy = newPolicy.getNext();
                newPolicy.set(newPolicy.size() - 2, ResourceResolution.TYPE);
            }
            return newPolicy;
        }
        return null;
    }

    private <T> MutableDisambiguationReport.Resource getComparingResource(MutableDisambiguationReport<T> report) {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return report.resource;
        }
        int parentIdx = size - 2;
        if (report.parents.size() > parentIdx) {
            return report.parents.get(parentIdx);
        }
        return null;
    }
}

