package io.quarkus.agroal.spi;

import io.quarkus.builder.item.MultiBuildItem;

/**
 * A build item that represents the "quarkus.datasource.db-kind" value.
 * This is generated by specific extensions that are meant to take away the burden of
 * configuring anything datasource related from the user.
 */
public final class DefaultDataSourceDbKindBuildItem extends MultiBuildItem {

    private final String dbKind;

    public DefaultDataSourceDbKindBuildItem(String dbKind) {
        this.dbKind = dbKind;
    }

    public String getDbKind() {
        return dbKind;
    }
}
