/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.BasicPropertiesConfigSource;
import com.mchange.v2.cfg.DelayedLogItem;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.cfg.PropertiesConfigSource;
import com.mchange.v3.hocon.HoconPropertiesConfigSource;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

final class BasicMultiPropertiesConfig
extends MultiPropertiesConfig {
    private static final String HOCON_CFG_CNAME = "com.typesafe.config.Config";
    private static final int HOCON_PFX_LEN = 6;
    static final BasicMultiPropertiesConfig EMPTY = new BasicMultiPropertiesConfig();
    String[] rps;
    Map propsByResourcePaths;
    Map propsByPrefixes;
    List parseMessages;
    Properties propsByKey;

    static boolean isHoconPath(String identifier) {
        return identifier.length() > 6 && identifier.substring(0, 6).toLowerCase().equals("hocon:");
    }

    private static PropertiesConfigSource configSource(String identifier) throws Exception {
        boolean hocon = BasicMultiPropertiesConfig.isHoconPath(identifier);
        if (!hocon && !identifier.startsWith("/")) {
            throw new IllegalArgumentException(String.format("Resource identifier '%s' is neither an absolute resource path nor a HOCON path. (Resource paths should be specified beginning with '/' or 'hocon:/')", identifier));
        }
        if (hocon) {
            try {
                Class.forName(HOCON_CFG_CNAME);
                return new HoconPropertiesConfigSource();
            }
            catch (ClassNotFoundException e) {
                String resourcePath;
                int sfx_index = identifier.lastIndexOf(35);
                String string = resourcePath = sfx_index > 0 ? identifier.substring(6, sfx_index) : identifier.substring(6);
                if (BasicMultiPropertiesConfig.class.getResource(resourcePath) == null) {
                    throw new FileNotFoundException(String.format("HOCON lib (typesafe-config) is not available. Also, no resource available at '%s' for HOCON identifier '%s'.", resourcePath, identifier));
                }
                throw new Exception(String.format("Could not decode HOCON resource '%s', even though the resource exists, because HOCON lib (typesafe-config) is not available.", identifier), e);
            }
        }
        if ("/".equals(identifier)) {
            return new SystemPropertiesConfigSource();
        }
        return new BasicPropertiesConfigSource();
    }

    public BasicMultiPropertiesConfig(String[] resourcePaths) {
        this(resourcePaths, null);
    }

    BasicMultiPropertiesConfig(String[] resourcePaths, List delayedLogItems) {
        this.firstInit(resourcePaths, delayedLogItems);
        this.finishInit(delayedLogItems);
    }

    public BasicMultiPropertiesConfig(String notionalResourcePath, Properties props) {
        this(new String[]{notionalResourcePath}, BasicMultiPropertiesConfig.resourcePathToPropertiesMap(notionalResourcePath, props), Collections.emptyList());
    }

    private static Map resourcePathToPropertiesMap(String notionalResourcePath, Properties props) {
        HashMap<String, Properties> out = new HashMap<String, Properties>();
        out.put(notionalResourcePath, props);
        return out;
    }

    BasicMultiPropertiesConfig(String[] rps, Map propsByResourcePaths, List parseMessages) {
        this.rps = rps;
        this.propsByResourcePaths = propsByResourcePaths;
        ArrayList dlis = new ArrayList();
        dlis.addAll(parseMessages);
        this.finishInit(dlis);
        this.parseMessages = dlis;
    }

    private BasicMultiPropertiesConfig() {
        this.rps = new String[0];
        Map propsByResourcePaths = Collections.emptyMap();
        Map propsByPrefixes = Collections.emptyMap();
        List parseMessages = Collections.emptyList();
        Properties propsByKey = new Properties();
    }

    private void firstInit(String[] resourcePaths, List delayedLogItems) {
        boolean syserr = false;
        if (delayedLogItems == null) {
            delayedLogItems = new ArrayList<DelayedLogItem>();
            syserr = true;
        }
        HashMap<String, Properties> pbrp = new HashMap<String, Properties>();
        ArrayList<String> goodPaths = new ArrayList<String>();
        for (String rp : resourcePaths) {
            try {
                PropertiesConfigSource cs = BasicMultiPropertiesConfig.configSource(rp);
                PropertiesConfigSource.Parse parse = cs.propertiesFromSource(rp);
                pbrp.put(rp, parse.getProperties());
                goodPaths.add(rp);
                delayedLogItems.addAll(parse.getDelayedLogItems());
            }
            catch (FileNotFoundException fnfe) {
                delayedLogItems.add(new DelayedLogItem(DelayedLogItem.Level.FINE, String.format("The configuration file for resource identifier '%s' could not be found. Skipping.", rp)));
            }
            catch (Exception e) {
                delayedLogItems.add(new DelayedLogItem(DelayedLogItem.Level.WARNING, String.format("An Exception occurred while trying to read configuration data at resource identifier '%s'.", rp), e));
            }
        }
        this.rps = goodPaths.toArray(new String[goodPaths.size()]);
        this.propsByResourcePaths = Collections.unmodifiableMap(pbrp);
        this.parseMessages = Collections.unmodifiableList(delayedLogItems);
        if (syserr) {
            BasicMultiPropertiesConfig.dumpToSysErr(delayedLogItems);
        }
    }

    private void finishInit(List delayedLogItems) {
        boolean syserr = false;
        if (delayedLogItems == null) {
            delayedLogItems = new ArrayList();
            syserr = true;
        }
        this.propsByPrefixes = Collections.unmodifiableMap(BasicMultiPropertiesConfig.extractPrefixMapFromRsrcPathMap(this.rps, this.propsByResourcePaths, delayedLogItems));
        this.propsByKey = BasicMultiPropertiesConfig.extractPropsByKey(this.rps, this.propsByResourcePaths, delayedLogItems);
        if (syserr) {
            BasicMultiPropertiesConfig.dumpToSysErr(delayedLogItems);
        }
    }

    public List getDelayedLogItems() {
        return this.parseMessages;
    }

    private static void dumpToSysErr(List delayedLogMessages) {
        for (Object o : delayedLogMessages) {
            System.err.println(o);
        }
    }

    private static String extractPrefix(String s) {
        int lastdot = s.lastIndexOf(46);
        if (lastdot < 0) {
            if ("".equals(s)) {
                return null;
            }
            return "";
        }
        return s.substring(0, lastdot);
    }

    private static Properties findProps(String rp, Map pbrp) {
        Properties p = (Properties)pbrp.get(rp);
        return p;
    }

    private static Properties extractPropsByKey(String[] resourcePaths, Map pbrp, List delayedLogItems) {
        Properties out = new Properties();
        for (String rp : resourcePaths) {
            Properties p = BasicMultiPropertiesConfig.findProps(rp, pbrp);
            if (p == null) {
                delayedLogItems.add(new DelayedLogItem(DelayedLogItem.Level.WARNING, BasicMultiPropertiesConfig.class.getName() + ".extractPropsByKey(): Could not find loaded properties for resource path: " + rp));
                continue;
            }
            for (Object kObj : p.keySet()) {
                if (!(kObj instanceof String)) {
                    String message = BasicMultiPropertiesConfig.class.getName() + ": Properties object found at resource path " + ("/".equals(rp) ? "[system properties]" : "'" + rp + "'") + "' contains a key that is not a String: " + kObj + "; Skipping...";
                    delayedLogItems.add(new DelayedLogItem(DelayedLogItem.Level.WARNING, message));
                    continue;
                }
                Object vObj = p.get(kObj);
                if (vObj != null && !(vObj instanceof String)) {
                    String message = BasicMultiPropertiesConfig.class.getName() + ": Properties object found at resource path " + ("/".equals(rp) ? "[system properties]" : "'" + rp + "'") + " contains a value that is not a String: " + vObj + "; Skipping...";
                    delayedLogItems.add(new DelayedLogItem(DelayedLogItem.Level.WARNING, message));
                    continue;
                }
                String key = (String)kObj;
                String val = (String)vObj;
                out.put(key, val);
            }
        }
        return out;
    }

    private static Map extractPrefixMapFromRsrcPathMap(String[] resourcePaths, Map pbrp, List delayedLogItems) {
        HashMap<String, Properties> out = new HashMap<String, Properties>();
        for (String rp : resourcePaths) {
            Properties p = BasicMultiPropertiesConfig.findProps(rp, pbrp);
            if (p == null) {
                String message = BasicMultiPropertiesConfig.class.getName() + ".extractPrefixMapFromRsrcPathMap(): Could not find loaded properties for resource path: " + rp;
                delayedLogItems.add(new DelayedLogItem(DelayedLogItem.Level.WARNING, message));
                continue;
            }
            for (Object kObj : p.keySet()) {
                if (!(kObj instanceof String)) {
                    String message = BasicMultiPropertiesConfig.class.getName() + ": Properties object found at resource path " + ("/".equals(rp) ? "[system properties]" : "'" + rp + "'") + "' contains a key that is not a String: " + kObj + "; Skipping...";
                    delayedLogItems.add(new DelayedLogItem(DelayedLogItem.Level.WARNING, message));
                    continue;
                }
                String key = (String)kObj;
                String prefix = BasicMultiPropertiesConfig.extractPrefix(key);
                while (prefix != null) {
                    Properties byPfx = (Properties)out.get(prefix);
                    if (byPfx == null) {
                        byPfx = new Properties();
                        out.put(prefix, byPfx);
                    }
                    byPfx.put(key, p.get(key));
                    prefix = BasicMultiPropertiesConfig.extractPrefix(prefix);
                }
            }
        }
        return out;
    }

    public String[] getPropertiesResourcePaths() {
        return (String[])this.rps.clone();
    }

    public Properties getPropertiesByResourcePath(String path) {
        Properties out = (Properties)this.propsByResourcePaths.get(path);
        return out == null ? new Properties() : out;
    }

    public Properties getPropertiesByPrefix(String pfx) {
        Properties out = (Properties)this.propsByPrefixes.get(pfx);
        return out == null ? new Properties() : out;
    }

    public String getProperty(String key) {
        return this.propsByKey.getProperty(key);
    }

    public String dump() {
        return String.format("[ propertiesByResourcePaths -> %s, propertiesByPrefixes -> %s ]", this.propsByResourcePaths, this.propsByPrefixes);
    }

    public String toString() {
        return super.toString() + " " + this.dump();
    }

    static final class SystemPropertiesConfigSource
    implements PropertiesConfigSource {
        SystemPropertiesConfigSource() {
        }

        public PropertiesConfigSource.Parse propertiesFromSource(String identifier) throws FileNotFoundException, Exception {
            if ("/".equals(identifier)) {
                return new PropertiesConfigSource.Parse((Properties)System.getProperties().clone(), Collections.<DelayedLogItem>emptyList());
            }
            throw new Exception(String.format("Unexpected identifier for System properties: '%s'", identifier));
        }
    }
}

