/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.BasicMultiPropertiesConfig;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class CombinedMultiPropertiesConfig
extends MultiPropertiesConfig {
    MultiPropertiesConfig[] configs;
    String[] resourcePaths;
    List parseMessages;

    CombinedMultiPropertiesConfig(MultiPropertiesConfig[] configs) {
        this.configs = configs;
        LinkedList<String> allPaths = new LinkedList<String>();
        for (int i = configs.length - 1; i >= 0; --i) {
            String[] rps = configs[i].getPropertiesResourcePaths();
            for (int j = rps.length - 1; j >= 0; --j) {
                String rp = rps[j];
                if (allPaths.contains(rp)) continue;
                allPaths.add(0, rp);
            }
        }
        this.resourcePaths = allPaths.toArray(new String[allPaths.size()]);
        LinkedList pms = new LinkedList();
        int len = configs.length;
        for (int i = 0; i < len; ++i) {
            pms.addAll(configs[i].getDelayedLogItems());
        }
        this.parseMessages = Collections.unmodifiableList(pms);
    }

    private Map getPropsByResourcePaths() {
        HashMap<String, Properties> out = new HashMap<String, Properties>();
        for (String rp : this.resourcePaths) {
            out.put(rp, this.getPropertiesByResourcePath(rp));
        }
        return Collections.unmodifiableMap(out);
    }

    public BasicMultiPropertiesConfig toBasic() {
        String[] rps = this.getPropertiesResourcePaths();
        Map pbrm = this.getPropsByResourcePaths();
        List pms = this.getDelayedLogItems();
        return new BasicMultiPropertiesConfig(rps, pbrm, pms);
    }

    public String[] getPropertiesResourcePaths() {
        return (String[])this.resourcePaths.clone();
    }

    public Properties getPropertiesByResourcePath(String path) {
        Properties out = new Properties();
        for (MultiPropertiesConfig config : this.configs) {
            Properties check = config.getPropertiesByResourcePath(path);
            if (check == null) continue;
            out.putAll((Map<?, ?>)check);
        }
        return out.size() > 0 ? out : null;
    }

    public Properties getPropertiesByPrefix(String pfx) {
        LinkedList<Map.Entry<Object, Object>> entries = new LinkedList<Map.Entry<Object, Object>>();
        for (int i = this.configs.length - 1; i >= 0; --i) {
            MultiPropertiesConfig config = this.configs[i];
            Properties properties = config.getPropertiesByPrefix(pfx);
            if (properties == null) continue;
            entries.addAll(0, properties.entrySet());
        }
        if (entries.size() == 0) {
            return null;
        }
        Properties out = new Properties();
        for (Map.Entry entry : entries) {
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }

    public String getProperty(String key) {
        for (int i = this.configs.length - 1; i >= 0; --i) {
            MultiPropertiesConfig config = this.configs[i];
            String check = config.getProperty(key);
            if (check == null) continue;
            return check;
        }
        return null;
    }

    public List getDelayedLogItems() {
        return this.parseMessages;
    }
}

