/*
 * Copyright 2014 Red Hat, Inc.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  and Apache License v2.0 which accompanies this distribution.
 *
 *  The Eclipse Public License is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  The Apache License v2.0 is available at
 *  http://www.opensource.org/licenses/apache2.0.php
 *
 *  You may elect to redistribute this code under either of these licenses.
 */

package io.vertx.test.codegen.testapi.javatypes;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

/**
 * @author <a href="http://tfox.org">Tim Fox</a>
 */
@VertxGen()
public interface MethodWithValidJavaTypeReturn {

  @GenIgnore(GenIgnore.PERMITTED_TYPE)
  Socket methodWithReturn();

  @GenIgnore(GenIgnore.PERMITTED_TYPE)
  List<Socket> methodWithListReturn();

  @GenIgnore(GenIgnore.PERMITTED_TYPE)
  Set<Socket> methodWithSetReturn();

  @GenIgnore(GenIgnore.PERMITTED_TYPE)
  Map<String, Socket> methodWithMapReturn();

}
