package io.vertx.ext.web.openapi;

import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.validation.RequestParameter;
import io.vertx.ext.web.validation.RequestParameters;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.assertj.core.api.Assertions.assertThat;

/**
 * This tests are autogenerated tests from https://github.com/pmlopes/slush-vertx
 * that checks compatibility of generated routes with OpenAPI spec.
 * PLEASE DON'T MODIFY THESE TESTS OR ADD ANY TEST HERE. If you need to add parameters validation tests,
 * put it in {@link RouterBuilderIntegrationTest}
 *
 * @author Francesco Guardiani @slinkydeveloper
 */
@ExtendWith(VertxExtension.class)
public class OpenAPI3ParametersUnitTest extends BaseRouterBuilderTest {

  public final static String SPEC_URL = "./src/test/resources/specs/openapi_parameters_compatibility_spec.yaml";
  public ParametersTestAPIClient apiClient;

  @BeforeEach
  @Override
  public void setUp(Vertx vertx) {
    super.setUp(vertx);
    apiClient = new ParametersTestAPIClient(client);
  }

  /**
   * Test: path_matrix_noexplode_string
   * Expected parameters sent:
   * color: ;color=blue
   * Expected response: {"color":"blue"}
   */
  @Test
  public void testPathMatrixNoexplodeString(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_matrix_noexplode_string").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isString()).isTrue();
          assertThat(color_path.getString()).isEqualTo("blue");
          res.put("color", color_path.getString());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_path;
      color_path = "blue";


      apiClient.pathMatrixNoexplodeString(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":\"blue\"}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_matrix_noexplode_array
   * Expected parameters sent:
   * color: ;color=blue,black,brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testPathMatrixNoexplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_matrix_noexplode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isJsonArray()).isTrue();
          res.put("color", color_path.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_path;
      color_path = new ArrayList<>();
      color_path.add("blue");
      color_path.add("black");
      color_path.add("brown");


      apiClient.pathMatrixNoexplodeArray(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_matrix_noexplode_object
   * Expected parameters sent:
   * color: ;color=R,100,G,200,B,150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testPathMatrixNoexplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_matrix_noexplode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isJsonObject()).isTrue();
          res.put("color", color_path.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_path;
      color_path = new HashMap<>();
      color_path.put("R", "100");
      color_path.put("G", "200");
      color_path.put("B", "150");


      apiClient.pathMatrixNoexplodeObject(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_matrix_explode_string
   * Expected parameters sent:
   * color: ;color=blue
   * Expected response: {"color":"blue"}
   */
  @Test
  public void testPathMatrixExplodeString(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_matrix_explode_string").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isString()).isTrue();
          assertThat(color_path.getString()).isEqualTo("blue");
          res.put("color", color_path.getString());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_path;
      color_path = "blue";


      apiClient.pathMatrixExplodeString(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":\"blue\"}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_matrix_explode_array
   * Expected parameters sent:
   * color: ;color=blue;color=black;color=brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testPathMatrixExplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_matrix_explode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isJsonArray()).isTrue();
          res.put("color", color_path.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_path;
      color_path = new ArrayList<>();
      color_path.add("blue");
      color_path.add("black");
      color_path.add("brown");


      apiClient.pathMatrixExplodeArray(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_matrix_explode_object
   * Expected parameters sent:
   * color: ;R=100;G=200;B=150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testPathMatrixExplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_matrix_explode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isJsonObject()).isTrue();
          res.put("color", color_path.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_path;
      color_path = new HashMap<>();
      color_path.put("R", "100");
      color_path.put("G", "200");
      color_path.put("B", "150");


      apiClient.pathMatrixExplodeObject(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_label_noexplode_string
   * Expected parameters sent:
   * color: .blue
   * Expected response: {"color":"blue"}
   */
  @Test
  public void testPathLabelNoexplodeString(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_label_noexplode_string").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isString()).isTrue();
          assertThat(color_path.getString()).isEqualTo("blue");
          res.put("color", color_path.getString());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_path;
      color_path = "blue";


      apiClient.pathLabelNoexplodeString(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":\"blue\"}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_label_noexplode_array
   * Expected parameters sent:
   * color: .blue.black.brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testPathLabelNoexplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_label_noexplode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isJsonArray()).isTrue();
          res.put("color", color_path.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_path;
      color_path = new ArrayList<>();
      color_path.add("blue");
      color_path.add("black");
      color_path.add("brown");


      apiClient.pathLabelNoexplodeArray(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_label_noexplode_object
   * Expected parameters sent:
   * color: .R.100.G.200.B.150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testPathLabelNoexplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_label_noexplode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isJsonObject()).isTrue();
          res.put("color", color_path.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_path;
      color_path = new HashMap<>();
      color_path.put("R", "100");
      color_path.put("G", "200");
      color_path.put("B", "150");


      apiClient.pathLabelNoexplodeObject(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_label_explode_string
   * Expected parameters sent:
   * color: .blue
   * Expected response: {"color":"blue"}
   */
  @Test
  public void testPathLabelExplodeString(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_label_explode_string").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isString()).isTrue();
          assertThat(color_path.getString()).isEqualTo("blue");
          res.put("color", color_path.getString());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_path;
      color_path = "blue";


      apiClient.pathLabelExplodeString(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":\"blue\"}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_label_explode_array
   * Expected parameters sent:
   * color: .blue.black.brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testPathLabelExplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_label_explode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isJsonArray()).isTrue();
          res.put("color", color_path.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_path;
      color_path = new ArrayList<>();
      color_path.add("blue");
      color_path.add("black");
      color_path.add("brown");


      apiClient.pathLabelExplodeArray(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_label_explode_object
   * Expected parameters sent:
   * color: .R=100.G=200.B=150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testPathLabelExplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_label_explode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isJsonObject()).isTrue();
          res.put("color", color_path.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_path;
      color_path = new HashMap<>();
      color_path.put("R", "100");
      color_path.put("G", "200");
      color_path.put("B", "150");


      apiClient.pathLabelExplodeObject(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_simple_noexplode_string
   * Expected parameters sent:
   * color: blue
   * Expected response: {"color":"blue"}
   */
  @Test
  public void testPathSimpleNoexplodeString(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_simple_noexplode_string").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isString()).isTrue();
          assertThat(color_path.getString()).isEqualTo("blue");
          res.put("color", color_path.getString());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_path;
      color_path = "blue";


      apiClient.pathSimpleNoexplodeString(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":\"blue\"}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_simple_noexplode_array
   * Expected parameters sent:
   * color: blue,black,brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testPathSimpleNoexplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_simple_noexplode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isJsonArray()).isTrue();
          res.put("color", color_path.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_path;
      color_path = new ArrayList<>();
      color_path.add("blue");
      color_path.add("black");
      color_path.add("brown");


      apiClient.pathSimpleNoexplodeArray(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_simple_noexplode_object
   * Expected parameters sent:
   * color: R,100,G,200,B,150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testPathSimpleNoexplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_simple_noexplode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isJsonObject()).isTrue();
          res.put("color", color_path.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_path;
      color_path = new HashMap<>();
      color_path.put("R", "100");
      color_path.put("G", "200");
      color_path.put("B", "150");


      apiClient.pathSimpleNoexplodeObject(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_simple_explode_string
   * Expected parameters sent:
   * color: blue
   * Expected response: {"color":"blue"}
   */
  @Test
  public void testPathSimpleExplodeString(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_simple_explode_string").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isString()).isTrue();
          assertThat(color_path.getString()).isEqualTo("blue");
          res.put("color", color_path.getString());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_path;
      color_path = "blue";


      apiClient.pathSimpleExplodeString(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":\"blue\"}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_simple_explode_array
   * Expected parameters sent:
   * color: blue,black,brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testPathSimpleExplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_simple_explode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isJsonArray()).isTrue();
          res.put("color", color_path.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_path;
      color_path = new ArrayList<>();
      color_path.add("blue");
      color_path.add("black");
      color_path.add("brown");


      apiClient.pathSimpleExplodeArray(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_simple_explode_object
   * Expected parameters sent:
   * color: R=100,G=200,B=150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testPathSimpleExplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_simple_explode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_path = params.pathParameter("color");
          assertThat(color_path).isNotNull();
          assertThat(color_path.isJsonObject()).isTrue();
          res.put("color", color_path.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_path;
      color_path = new HashMap<>();
      color_path.put("R", "100");
      color_path.put("G", "200");
      color_path.put("B", "150");


      apiClient.pathSimpleExplodeObject(color_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_multi_simple_label
   * Expected parameters sent:
   * color_simple: blue
   * color_label: .blue.black.brown
   * Expected response: {"color_simple":"blue","color_label":["blue","black","brown"]}
   */
  @Test
  public void testPathMultiSimpleLabel(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_multi_simple_label").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter colorSimple_path = params.pathParameter("color_simple");
          assertThat(colorSimple_path).isNotNull();
          assertThat(colorSimple_path.isString()).isTrue();
          assertThat(colorSimple_path.getString()).isEqualTo("blue");
          res.put("color_simple", colorSimple_path.getString());
          RequestParameter colorLabel_path = params.pathParameter("color_label");
          assertThat(colorLabel_path).isNotNull();
          assertThat(colorLabel_path.isJsonArray()).isTrue();
          res.put("color_label", colorLabel_path.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String colorSimple_path;
      colorSimple_path = "blue";
      List<Object> colorLabel_path;
      colorLabel_path = new ArrayList<>();
      colorLabel_path.add("blue");
      colorLabel_path.add("black");
      colorLabel_path.add("brown");


      apiClient.pathMultiSimpleLabel(colorSimple_path, colorLabel_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color_simple\":\"blue\",\"color_label\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_multi_simple_matrix
   * Expected parameters sent:
   * color_simple: blue
   * color_matrix: ;color=blue,black,brown
   * Expected response: {"color_simple":"blue","color_matrix":["blue","black","brown"]}
   */
  @Test
  public void testPathMultiSimpleMatrix(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_multi_simple_matrix").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter colorSimple_path = params.pathParameter("color_simple");
          assertThat(colorSimple_path).isNotNull();
          assertThat(colorSimple_path.isString()).isTrue();
          assertThat(colorSimple_path.getString()).isEqualTo("blue");
          res.put("color_simple", colorSimple_path.getString());
          RequestParameter colorMatrix_path = params.pathParameter("color_matrix");
          assertThat(colorMatrix_path).isNotNull();
          assertThat(colorMatrix_path.isJsonArray()).isTrue();
          res.put("color_matrix", colorMatrix_path.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String colorSimple_path;
      colorSimple_path = "blue";
      List<Object> colorMatrix_path;
      colorMatrix_path = new ArrayList<>();
      colorMatrix_path.add("blue");
      colorMatrix_path.add("black");
      colorMatrix_path.add("brown");


      apiClient.pathMultiSimpleMatrix(colorSimple_path, colorMatrix_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color_simple\":\"blue\",\"color_matrix\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: path_multi_label_matrix
   * Expected parameters sent:
   * color_label: .blue.black.brown
   * color_matrix: ;R=100;G=200;B=150
   * Expected response: {"color_label":["blue","black","brown"],"color_matrix":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testPathMultiLabelMatrix(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("path_multi_label_matrix").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter colorLabel_path = params.pathParameter("color_label");
          assertThat(colorLabel_path).isNotNull();
          assertThat(colorLabel_path.isJsonArray()).isTrue();
          res.put("color_label", colorLabel_path.getJsonArray());
          RequestParameter colorMatrix_path = params.pathParameter("color_matrix");
          assertThat(colorMatrix_path).isNotNull();
          assertThat(colorMatrix_path.isJsonObject()).isTrue();
          res.put("color_matrix", colorMatrix_path.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> colorLabel_path;
      colorLabel_path = new ArrayList<>();
      colorLabel_path.add("blue");
      colorLabel_path.add("black");
      colorLabel_path.add("brown");
      Map<String, Object> colorMatrix_path;
      colorMatrix_path = new HashMap<>();
      colorMatrix_path.put("R", "100");
      colorMatrix_path.put("G", "200");
      colorMatrix_path.put("B", "150");


      apiClient.pathMultiLabelMatrix(colorLabel_path, colorMatrix_path, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color_label\":[\"blue\",\"black\",\"brown\"],\"color_matrix\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_form_noexplode_empty
   * Expected parameters sent:
   * color: color=
   * Expected response: {"color":null}
   */
  @Test
  public void testQueryFormNoexplodeEmpty(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_form_noexplode_empty").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isEmpty()).isTrue();
          res.putNull("color");

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_query;
      color_query = "";


      apiClient.queryFormNoexplodeEmpty(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":null}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_form_noexplode_string
   * Expected parameters sent:
   * color: color=blue
   * Expected response: {"color":"blue"}
   */
  @Test
  public void testQueryFormNoexplodeString(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_form_noexplode_string").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isString()).isTrue();
          assertThat(color_query.getString()).isEqualTo("blue");
          res.put("color", color_query.getString());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_query;
      color_query = "blue";


      apiClient.queryFormNoexplodeString(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":\"blue\"}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_form_noexplode_array
   * Expected parameters sent:
   * color: color=blue,black,brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testQueryFormNoexplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_form_noexplode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isJsonArray()).isTrue();
          res.put("color", color_query.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_query;
      color_query = new ArrayList<>();
      color_query.add("blue");
      color_query.add("black");
      color_query.add("brown");


      apiClient.queryFormNoexplodeArray(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_form_noexplode_object
   * Expected parameters sent:
   * color: color=R,100,G,200,B,150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testQueryFormNoexplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_form_noexplode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isJsonObject()).isTrue();
          res.put("color", color_query.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_query;
      color_query = new HashMap<>();
      color_query.put("R", "100");
      color_query.put("G", "200");
      color_query.put("B", "150");


      apiClient.queryFormNoexplodeObject(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_form_explode_empty
   * Expected parameters sent:
   * color: color=
   * Expected response: {"color":null}
   */
  @Test
  public void testQueryFormExplodeEmpty(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_form_explode_empty").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isEmpty()).isTrue();
          res.putNull("color");

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_query;
      color_query = "";


      apiClient.queryFormExplodeEmpty(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":null}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_form_explode_string
   * Expected parameters sent:
   * color: color=blue
   * Expected response: {"color":"blue"}
   */
  @Test
  public void testQueryFormExplodeString(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_form_explode_string").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isString()).isTrue();
          assertThat(color_query.getString()).isEqualTo("blue");
          res.put("color", color_query.getString());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_query;
      color_query = "blue";


      apiClient.queryFormExplodeString(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":\"blue\"}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_form_explode_array
   * Expected parameters sent:
   * color: color=blue&color=black&color=brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testQueryFormExplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_form_explode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isJsonArray()).isTrue();
          res.put("color", color_query.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_query;
      color_query = new ArrayList<>();
      color_query.add("blue");
      color_query.add("black");
      color_query.add("brown");


      apiClient.queryFormExplodeArray(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_form_explode_object
   * Expected parameters sent:
   * color: R=100&G=200&B=150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testQueryFormExplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_form_explode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isJsonObject()).isTrue();
          res.put("color", color_query.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_query;
      color_query = new HashMap<>();
      color_query.put("R", "100");
      color_query.put("G", "200");
      color_query.put("B", "150");


      apiClient.queryFormExplodeObject(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_spaceDelimited_noexplode_array
   * Expected parameters sent:
   * color: blue%20black%20brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testQuerySpaceDelimitedNoexplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_spaceDelimited_noexplode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isJsonArray()).isTrue();
          res.put("color", color_query.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_query;
      color_query = new ArrayList<>();
      color_query.add("blue");
      color_query.add("black");
      color_query.add("brown");


      apiClient.querySpaceDelimitedNoexplodeArray(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_spaceDelimited_noexplode_object
   * Expected parameters sent:
   * color: R%20100%20G%20200%20B%20150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testQuerySpaceDelimitedNoexplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_spaceDelimited_noexplode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isJsonObject()).isTrue();
          res.put("color", color_query.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_query;
      color_query = new HashMap<>();
      color_query.put("R", "100");
      color_query.put("G", "200");
      color_query.put("B", "150");


      apiClient.querySpaceDelimitedNoexplodeObject(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_pipeDelimited_noexplode_array
   * Expected parameters sent:
   * color: blue|black|brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testQueryPipeDelimitedNoexplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_pipeDelimited_noexplode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isJsonArray()).isTrue();
          res.put("color", color_query.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_query;
      color_query = new ArrayList<>();
      color_query.add("blue");
      color_query.add("black");
      color_query.add("brown");


      apiClient.queryPipeDelimitedNoexplodeArray(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_pipeDelimited_noexplode_object
   * Expected parameters sent:
   * color: R|100|G|200|B|150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testQueryPipeDelimitedNoexplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_pipeDelimited_noexplode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isJsonObject()).isTrue();
          res.put("color", color_query.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_query;
      color_query = new HashMap<>();
      color_query.put("R", "100");
      color_query.put("G", "200");
      color_query.put("B", "150");


      apiClient.queryPipeDelimitedNoexplodeObject(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: query_deepObject_explode_object
   * Expected parameters sent:
   * color: color[R]=100&color[G]=200&color[B]=150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testQueryDeepObjectExplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("query_deepObject_explode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_query = params.queryParameter("color");
          assertThat(color_query).isNotNull();
          assertThat(color_query.isJsonObject()).isTrue();
          res.put("color", color_query.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_query;
      color_query = new HashMap<>();
      color_query.put("R", "100");
      color_query.put("G", "200");
      color_query.put("B", "150");


      apiClient.queryDeepObjectExplodeObject(color_query, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: cookie_form_noexplode_empty
   * Expected parameters sent:
   * color: color=
   * Expected response: {"color":null}
   */
  @Test
  public void testCookieFormNoexplodeEmpty(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("cookie_form_noexplode_empty").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_cookie = params.cookieParameter("color");
          assertThat(color_cookie).isNotNull();
          assertThat(color_cookie.isEmpty()).isTrue();
          res.putNull("color");

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_cookie;
      color_cookie = "";


      apiClient.cookieFormNoexplodeEmpty(color_cookie, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":null}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: cookie_form_noexplode_string
   * Expected parameters sent:
   * color: color=blue
   * Expected response: {"color":"blue"}
   */
  @Test
  public void testCookieFormNoexplodeString(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("cookie_form_noexplode_string").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_cookie = params.cookieParameter("color");
          assertThat(color_cookie).isNotNull();
          assertThat(color_cookie.isString()).isTrue();
          assertThat(color_cookie.getString()).isEqualTo("blue");
          res.put("color", color_cookie.getString());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_cookie;
      color_cookie = "blue";


      apiClient.cookieFormNoexplodeString(color_cookie, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":\"blue\"}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: cookie_form_noexplode_array
   * Expected parameters sent:
   * color: color=blue,black,brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testCookieFormNoexplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("cookie_form_noexplode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_cookie = params.cookieParameter("color");
          assertThat(color_cookie).isNotNull();
          assertThat(color_cookie.isJsonArray()).isTrue();
          res.put("color", color_cookie.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_cookie;
      color_cookie = new ArrayList<>();
      color_cookie.add("blue");
      color_cookie.add("black");
      color_cookie.add("brown");


      apiClient.cookieFormNoexplodeArray(color_cookie, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: cookie_form_noexplode_object
   * Expected parameters sent:
   * color: color=R,100,G,200,B,150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testCookieFormNoexplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("cookie_form_noexplode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_cookie = params.cookieParameter("color");
          assertThat(color_cookie).isNotNull();
          assertThat(color_cookie.isJsonObject()).isTrue();
          res.put("color", color_cookie.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_cookie;
      color_cookie = new HashMap<>();
      color_cookie.put("R", "100");
      color_cookie.put("G", "200");
      color_cookie.put("B", "150");


      apiClient.cookieFormNoexplodeObject(color_cookie, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: cookie_form_explode_empty
   * Expected parameters sent:
   * color: color=
   * Expected response: {"color":null}
   */
  @Test
  public void testCookieFormExplodeEmpty(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("cookie_form_explode_empty").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_cookie = params.cookieParameter("color");
          assertThat(color_cookie).isNotNull();
          assertThat(color_cookie.isEmpty()).isTrue();
          res.putNull("color");

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_cookie;
      color_cookie = "";


      apiClient.cookieFormExplodeEmpty(color_cookie, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":null}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: cookie_form_explode_string
   * Expected parameters sent:
   * color: color=blue
   * Expected response: {"color":"blue"}
   */
  @Test
  public void testCookieFormExplodeString(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("cookie_form_explode_string").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_cookie = params.cookieParameter("color");
          assertThat(color_cookie).isNotNull();
          assertThat(color_cookie.isString()).isTrue();
          assertThat(color_cookie.getString()).isEqualTo("blue");
          res.put("color", color_cookie.getString());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_cookie;
      color_cookie = "blue";


      apiClient.cookieFormExplodeString(color_cookie, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":\"blue\"}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: cookie_form_explode_array
   * Expected parameters sent:
   * color: color=blue&color=black&color=brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testCookieFormExplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("cookie_form_explode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_cookie = params.cookieParameter("color");
          assertThat(color_cookie).isNotNull();
          assertThat(color_cookie.isJsonArray()).isTrue();
          res.put("color", color_cookie.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_cookie;
      color_cookie = new ArrayList<>();
      color_cookie.add("blue");
      color_cookie.add("black");
      color_cookie.add("brown");


      apiClient.cookieFormExplodeArray(color_cookie, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: cookie_form_explode_object
   * Expected parameters sent:
   * color: R=100&G=200&B=150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testCookieFormExplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("cookie_form_explode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_cookie = params.cookieParameter("color");
          assertThat(color_cookie).isNotNull();
          assertThat(color_cookie.isJsonObject()).isTrue();
          res.put("color", color_cookie.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_cookie;
      color_cookie = new HashMap<>();
      color_cookie.put("R", "100");
      color_cookie.put("G", "200");
      color_cookie.put("B", "150");


      apiClient.cookieFormExplodeObject(color_cookie, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: header_simple_noexplode_string
   * Expected parameters sent:
   * color: blue
   * Expected response: {"color":"blue"}
   */
  @Test
  public void testHeaderSimpleNoexplodeString(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("header_simple_noexplode_string").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_header = params.headerParameter("color");
          assertThat(color_header).isNotNull();
          assertThat(color_header.isString()).isTrue();
          assertThat(color_header.getString()).isEqualTo("blue");
          res.put("color", color_header.getString());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_header;
      color_header = "blue";


      apiClient.headerSimpleNoexplodeString(color_header, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":\"blue\"}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: header_simple_noexplode_array
   * Expected parameters sent:
   * color: blue,black,brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testHeaderSimpleNoexplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("header_simple_noexplode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_header = params.headerParameter("color");
          assertThat(color_header).isNotNull();
          assertThat(color_header.isJsonArray()).isTrue();
          res.put("color", color_header.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_header;
      color_header = new ArrayList<>();
      color_header.add("blue");
      color_header.add("black");
      color_header.add("brown");


      apiClient.headerSimpleNoexplodeArray(color_header, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: header_simple_noexplode_object
   * Expected parameters sent:
   * color: R,100,G,200,B,150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testHeaderSimpleNoexplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("header_simple_noexplode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_header = params.headerParameter("color");
          assertThat(color_header).isNotNull();
          assertThat(color_header.isJsonObject()).isTrue();
          res.put("color", color_header.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_header;
      color_header = new HashMap<>();
      color_header.put("R", "100");
      color_header.put("G", "200");
      color_header.put("B", "150");


      apiClient.headerSimpleNoexplodeObject(color_header, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: header_simple_explode_string
   * Expected parameters sent:
   * color: blue
   * Expected response: {"color":"blue"}
   */
  @Test
  public void testHeaderSimpleExplodeString(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("header_simple_explode_string").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_header = params.headerParameter("color");
          assertThat(color_header).isNotNull();
          assertThat(color_header.isString()).isTrue();
          assertThat(color_header.getString()).isEqualTo("blue");
          res.put("color", color_header.getString());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      String color_header;
      color_header = "blue";


      apiClient.headerSimpleExplodeString(color_header, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":\"blue\"}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: header_simple_explode_array
   * Expected parameters sent:
   * color: blue,black,brown
   * Expected response: {"color":["blue","black","brown"]}
   */
  @Test
  public void testHeaderSimpleExplodeArray(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("header_simple_explode_array").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_header = params.headerParameter("color");
          assertThat(color_header).isNotNull();
          assertThat(color_header.isJsonArray()).isTrue();
          res.put("color", color_header.getJsonArray());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      List<Object> color_header;
      color_header = new ArrayList<>();
      color_header.add("blue");
      color_header.add("black");
      color_header.add("brown");


      apiClient.headerSimpleExplodeArray(color_header, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

  /**
   * Test: header_simple_explode_object
   * Expected parameters sent:
   * color: R=100,G=200,B=150
   * Expected response: {"color":{"R":"100","G":"200","B":"150"}}
   */
  @Test
  public void testHeaderSimpleExplodeObject(Vertx vertx, VertxTestContext testContext) {
    loadBuilderAndStartServer(vertx, SPEC_URL, testContext, routerBuilder -> {
      routerBuilder.setOptions(new RouterBuilderOptions().setMountNotImplementedHandler(false));
      routerBuilder.operation("header_simple_explode_object").handler(routingContext -> {
        RequestParameters params = routingContext.get("parsedParameters");
        JsonObject res = new JsonObject();

        testContext.verify(() -> {
          RequestParameter color_header = params.headerParameter("color");
          assertThat(color_header).isNotNull();
          assertThat(color_header.isJsonObject()).isTrue();
          res.put("color", color_header.getJsonObject());

        });

        routingContext.response()
          .setStatusCode(200)
          .setStatusMessage("OK")
          .putHeader("content-type", "application/json; charset=utf-8")
          .end(res.encode());
      });
    }).onComplete(h -> {
      Map<String, Object> color_header;
      color_header = new HashMap<>();
      color_header.put("R", "100");
      color_header.put("G", "200");
      color_header.put("B", "150");


      apiClient.headerSimpleExplodeObject(color_header, (AsyncResult<HttpResponse> ar) -> {
        if (ar.succeeded()) {
          testContext.verify(() -> {
            assertThat(ar.result().bodyAsJsonObject()).isEqualTo(new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}"));
          });
          testContext.completeNow();
        } else {
          testContext.failNow(ar.cause());
        }
      });
    });

  }

}
