/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ButtonModel;
import javax.swing.SwingUtilities;
import org.jvnet.substance.utils.Trackable;

public class RolloverControlListener
implements MouseListener,
MouseMotionListener {
    private boolean isMouseInside;
    private ButtonModel model;
    private Trackable trackableUI;
    private boolean isRedispatching;

    public RolloverControlListener(Trackable trackableUI, ButtonModel model) {
        this.trackableUI = trackableUI;
        this.model = model;
        this.isMouseInside = false;
    }

    public void setRedispatching(boolean isRedispatching) {
        this.isRedispatching = isRedispatching;
    }

    public void mouseEntered(MouseEvent e) {
        boolean isInside;
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        this.isMouseInside = isInside = this.trackableUI.isInside(e);
        this.model.setRollover(isInside);
        this.model.setEnabled(component.isEnabled());
        this.redispatchToParent(e);
    }

    public void mouseExited(MouseEvent e) {
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        this.isMouseInside = false;
        this.model.setRollover(false);
        this.model.setEnabled(component.isEnabled());
        this.redispatchToParent(e);
    }

    public void mouseReleased(MouseEvent e) {
        boolean isInside;
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        this.isMouseInside = isInside = this.trackableUI.isInside(e);
        this.model.setRollover(this.isMouseInside);
        this.model.setPressed(false);
        this.model.setArmed(false);
        this.model.setSelected(false);
        this.model.setEnabled(component.isEnabled());
        this.redispatchToParent(e);
    }

    public void mousePressed(MouseEvent e) {
        boolean isInside;
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        this.isMouseInside = isInside = this.trackableUI.isInside(e);
        this.model.setRollover(this.isMouseInside);
        if (this.isMouseInside) {
            this.model.setPressed(true);
            this.model.setArmed(true);
            this.model.setSelected(true);
        }
        this.model.setEnabled(component.isEnabled());
        this.redispatchToParent(e);
    }

    public void mouseDragged(MouseEvent e) {
        boolean isInside;
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        this.isMouseInside = isInside = this.trackableUI.isInside(e);
        this.model.setEnabled(component.isEnabled());
        this.redispatchToParent(e);
    }

    public void mouseMoved(MouseEvent e) {
        boolean isInside;
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        this.isMouseInside = isInside = this.trackableUI.isInside(e);
        this.model.setRollover(isInside);
        this.model.setEnabled(component.isEnabled());
        this.redispatchToParent(e);
    }

    public void mouseClicked(MouseEvent e) {
        this.redispatchToParent(e);
    }

    private void redispatchToParent(final MouseEvent e) {
        if (!this.isRedispatching) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Component comp = (Component)e.getSource();
                Container parent = comp.getParent();
                if (parent == null) {
                    return;
                }
                Point contPoint = SwingUtilities.convertPoint(comp, e.getPoint(), parent);
                int eventId = e.getID();
                if (eventId == 504 || eventId == 505) {
                    eventId = 503;
                }
                parent.dispatchEvent(new MouseEvent(parent, eventId, e.getWhen(), e.getModifiers(), contPoint.x, contPoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
            }
        });
    }
}

