package com.redhat.installer.asconfiguration.ports.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;
import com.redhat.installer.asconfiguration.ports.utils.PortUtils;
import com.redhat.installer.ports.utils.PortOffset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Simple class to adjust existing port variables with an offset. Variables are specified via parameters
 * to the action in install.xml
 * Created by thauser on 1/12/16.
 */
public class OffsetVariableAdjuster implements PanelAction {

    private List<String> variablesToAdjust = new ArrayList<String>();

    @Override
    public void executeAction(AutomatedInstallData adata, AbstractUIHandler handler) {

        int offset = PortOffset.get();
        for (String var : variablesToAdjust) {
            String value = adata.getVariable(var);
            int numericValue = value != null ? PortUtils.getPort(value) : -1;
            if (numericValue < 0)
                continue;
            numericValue+=offset;
            adata.setVariable("adjusted."+var, Integer.toString(numericValue));
        }
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
        variablesToAdjust = Arrays.asList(configuration.getProperty("variables").split(","));
    }
}
