package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import org.jboss.dmr.ModelNode;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by thauser on 7/29/15.
 */
public class AddQuartzDatasources extends PostInstallation{
    @Override
    protected Class getClassName() {
        return AddQuartzDatasources.class;
    }

    @Override
    protected boolean performOperation() {
        return installQuartzDatasources();
    }

    private static boolean installQuartzDatasources() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        boolean result = true;
        String quartzJdbcName = idata.getVariable("jdbc.driver.name");
        String quartzUsername = idata.getVariable("quartz.db.username");
        String quartzPassword = idata.getVariable("quartz.db.password");
        String quartzUrl = idata.getVariable("quartz.db.url");
        result = result && serverCommands.installDatasourceUsernamePwd("quartzDs", "java:jboss/datasources/quartzDs",quartzJdbcName,quartzUrl, "0", "20",quartzUsername, quartzPassword, null);
        if (!result){
            ProcessPanelHelper.printToPanel(mHandler, String.format(""),true);
            return false;
        }
        result = result && serverCommands.installDatasourceUsernamePwd("quartzUnmanagedDs", "java:jboss/datasources/quartzUnmanagedDs",quartzJdbcName,quartzUrl, "0", "20",quartzUsername, quartzPassword, "false");
        if (!result){
            ProcessPanelHelper.printToPanel(mHandler, String.format(""),true);
            return false;
        }
        // TODO: success
        ProcessPanelHelper.printToPanel(mHandler, String.format(""), false);
        return result;
    }
}
