package com.redhat.installer.tests.installation.processpanel;

import com.redhat.installer.framework.mock.MockResourceBuilder;
import com.redhat.installer.framework.testers.ProcessPanelTester;
import com.redhat.installer.installation.processpanel.TomcatModifyContext;
import com.redhat.installer.tests.TestUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Collectors;

import static junit.framework.TestCase.assertFalse;
import static junit.framework.TestCase.assertTrue;

public class TomcatModifyContextTest extends ProcessPanelTester {
    private final String contextXml = "/tomcat/context.xml";
    private final String copiedXml = "/conf/context.xml";


    @Before
    public void setUp() throws Exception {
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "", "");
    }

    @After
    public void cleanup() throws Exception {
        if (Files.exists(Paths.get(idata.getInstallPath() + copiedXml))) {
            MockResourceBuilder.deleteFile(idata.getInstallPath() + copiedXml);
        }
    }

    @Test
    public void testSuccess() throws Exception {
        MockResourceBuilder.copyResourceToInstall(contextXml, idata.getInstallPath() + copiedXml);
        boolean result = TomcatModifyContext.run(handler, new String[]{});
        assertCorrect(result);
    }

    private void assertCorrect(boolean result) throws Exception {
        assertTrue(result);
        String newFileString = Files.lines(Paths.get(tempFolder.getRoot().getPath() + copiedXml)).collect(Collectors.joining("\n"));
        Document modifiedXml = Jsoup.parse(newFileString, "", Parser.xmlParser());
        Elements contextElement = modifiedXml.getElementsByTag("Context");
        assertFalse(contextElement.isEmpty());
        Elements addedElement = modifiedXml.select("Resource[name=kieServerDS][auth=Container][loginTimeout=0][type=org.h2.jdbcx.JdbcDataSource][user=sa][password=sa][url=jdbc:h2:mem:testdb;DB_CLOSE_DELAY=-1;MVCC=TRUE][description=H2 Data Source][loginTimeout=0][testOnBorrow=false][factory=org.h2.jdbcx.JdbcDataSourceFactory]");
        assertTrue(addedElement != null && addedElement.size() == 1);
    }

}
