package com.redhat.installer.tests.installation.validator;

import com.redhat.installer.framework.testers.ParameteredDataValidatorTester;
import com.redhat.installer.installation.validator.NotEqualDataValidator;
import com.redhat.installer.tests.TestUtils;
import org.junit.Before;
import org.junit.Test;

import java.util.HashMap;
import java.util.Map;

public class NotEqualDataValidatorTest extends ParameteredDataValidatorTester {
    @Before
    public void setup() throws Exception {
        pdv = new NotEqualDataValidator();
        pdv.setParameters(setTestParameters("testvar", "somethingnonempty", "test.message"));
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "test.message");
    }

    @Test
    public void testArbitraryValue(){
        idata.setVariable("testvar", "somethingnonempty");
        assertStatusError();
        assertLangpack("test.message");
    }

    @Test
    public void testEmptyValue(){
        pdv.setParameters(setTestParameters("testvar", "", "test.message"));
        idata.setVariable("testvar", "");
        assertStatusError();
        assertLangpack("test.message");
    }

    @Test
    public void testUnequalValue(){
        idata.setVariable("testvar", "somethingotherthantestvalue");
        assertStatusOk();
    }

    @Test
    public void testNullVariable(){
        assertStatusError();
        assertLangpack("test.message");
    }

    @Test
    public void testNullValue(){
        idata.setVariable("testvar", "somethinghere");
        pdv.setParameters(setTestParameters("testvar", null, "test.message"));
        assertStatusError();
        assertLangpack("test.message");
    }

    private Map<String,String> setTestParameters(String variable, String value, String messageId){
        Map<String,String> params = new HashMap<>();
        params.put("variable", variable);
        params.put("value", value);
        params.put("messageId", messageId);
        return params;
    }
}
