/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.appformer.maven.integration.Aether;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.m2repo.service.M2RepoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class M2ServletContextListener
implements ServletContextListener {
    private final String JAR_EXT = ".jar";
    private final String WEB_INF_FOLDER = "WEB-INF";
    private final String LIB_FOLDER = "lib";
    private final String CTX_JARS = "CTX_JARS";
    private Logger logger = LoggerFactory.getLogger(M2ServletContextListener.class);
    private GuvnorM2Repository repository;
    private M2RepoService repoService;

    @Inject
    public M2ServletContextListener(M2RepoService repo, GuvnorM2Repository repository) {
        this.repoService = repo;
        this.repository = repository;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext ctx = servletContextEvent.getServletContext();
        String jarsPath = ctx.getRealPath(this.getJarsFolder());
        this.deployJarsFromWar(jarsPath, ctx);
        this.logger.info("M2ServletContextListener contextInitialized");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        servletContextEvent.getServletContext().removeAttribute("CTX_JARS");
    }

    private String getJarsFolder() {
        StringBuilder sb = new StringBuilder();
        sb.append(File.separator).append("WEB-INF").append(File.separator).append("lib");
        return sb.toString();
    }

    private void deployJarsFromWar(String path, ServletContext ctx) {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(Paths.get("file://" + path, new String[0]));){
            for (Path p : ds) {
                if (Files.isDirectory(p, new LinkOption[0]) || !p.endsWith(".jar")) continue;
                String filePath = p.toAbsolutePath().toString();
                this.deployJar(filePath, ctx.getResourceAsStream(filePath));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public GAV deployJar(String file, InputStream is) {
        GAV gav = new GAV();
        Properties props = this.readZipFile(file);
        if (props != null) {
            gav = new GAV(props.getProperty("groupId"), props.getProperty("artifactId"), props.getProperty("version"));
            this.deploy(gav, file);
        }
        return gav;
    }

    public Properties readZipFile(String zipFilePath) {
        try {
            ZipFile zipFile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (entry.isDirectory() || !entry.getName().startsWith("META-INF/maven") || !entry.getName().endsWith("pom.properties")) continue;
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                Properties props = new Properties();
                props.load(bis);
                bis.close();
                return props;
            }
        }
        catch (IOException e) {
            this.logger.error("IOError :" + e);
            e.printStackTrace();
        }
        return null;
    }

    public boolean deploy(GAV gav, String jarFile) {
        DefaultArtifact jarArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), "jar", gav.getVersion());
        jarArtifact = jarArtifact.setFile(new File(jarFile));
        try {
            InstallRequest installRequest = new InstallRequest();
            installRequest.addArtifact((Artifact)jarArtifact);
            InstallResult result = Aether.getAether().getSystem().install(Aether.getAether().getSession(), installRequest);
            return result.getArtifacts().size() == 1;
        }
        catch (InstallationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

