/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.fonts;

import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import javax.swing.UIDefaults;
import org.jvnet.substance.fonts.FontPolicy;
import org.jvnet.substance.fonts.FontSet;
import org.jvnet.substance.fonts.FontSets;

public class DefaultGnomeFontPolicy
implements FontPolicy {
    private static double fontScale;

    public FontSet getFontSet(String lafName, UIDefaults table) {
        Object defaultGtkFontName = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Gtk/FontName");
        String family = "";
        int style = 0;
        int size = 10;
        if (defaultGtkFontName instanceof String) {
            String pangoName = (String)defaultGtkFontName;
            StringTokenizer tok = new StringTokenizer(pangoName);
            while (tok.hasMoreTokens()) {
                String word = tok.nextToken();
                boolean allDigits = true;
                for (int i = 0; i < word.length(); ++i) {
                    if (Character.isDigit(word.charAt(i))) continue;
                    allDigits = false;
                    break;
                }
                if (word.equalsIgnoreCase("italic")) {
                    style |= 2;
                    continue;
                }
                if (word.equalsIgnoreCase("bold")) {
                    style |= 1;
                    continue;
                }
                if (allDigits) {
                    try {
                        size = Integer.parseInt(word);
                    }
                    catch (NumberFormatException nfe) {
                        size = 10;
                    }
                    continue;
                }
                if (family.length() > 0) {
                    family = family + " ";
                }
                family = family + word;
            }
        }
        double dsize = size;
        int dpi = 96;
        Object value = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
        if (value instanceof Integer) {
            dpi = (Integer)value / 1024;
            if (dpi == -1) {
                dpi = 96;
            }
            if (dpi < 50) {
                dpi = 50;
            }
            dsize = (double)(dpi * size) / 72.0;
        } else {
            dsize = (double)size * fontScale;
        }
        size = (int)(dsize + 0.5);
        if (size < 1) {
            size = 1;
        }
        if (family.length() == 0) {
            family = "sans";
        }
        Font controlFont = new Font(family, style, size);
        return FontSets.createDefaultFontSet(controlFont);
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        AffineTransform at = gc.getNormalizingTransform();
        fontScale = at.getScaleY();
    }
}

