package com.redhat.installer.tests.asconfiguration.javaopts;

import com.redhat.installer.asconfiguration.javaopts.JavaOptsValidator;
import com.redhat.installer.framework.mock.MockProcessingClient;
import com.redhat.installer.framework.testers.ValidatorTester;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * Created by aabulawi on 17/04/15.
 */
public class JavaOptsValidatorTest extends ValidatorTester {

    @Before
    public void setUp() throws Exception{
        v = new JavaOptsValidator();
        mpc = new MockProcessingClient();
    }

    @After
    public void tearDown() throws Exception {
        v = null;
        mpc = null;
    }

    @Test
    public void testValidJavaOpts() throws Exception{
        mpc.addToFields("-Xmx300m -DskipTests=True");
        assertOkResult();
    }

    @Test
    public void testInvalidJavaOpts() throws Exception{
        mpc.addToFields("-Xmx500m -Xms600m -DskipTests");
        assertErrorResult();
    }

    @Test
    public void testVersionInJavaOpts() throws Exception {
        mpc.addToFields("-Xmx500m -Xms600m -version");
        assertErrorResult();
    }

    @Test
    public void testEmptyJavaOpts() throws Exception {
        mpc.addToFields("");
        assertOkResult();
    }

}
