package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.UserInputPanel;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by anestico on 14/08/14.
 */
public class SecurityDomain extends PostInstallation {
    @Override
    protected Class getClassName() {
        return SecurityDomain.class;
    }

    @Override
    protected boolean performOperation() {
        return installSecurityDomain();
    }

    private static boolean installSecurityDomain() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        ArrayList<String> secDomAuthenCode = new ArrayList<String>();
        ArrayList<String> secDomAuthenFlag = new ArrayList<String>();
        ArrayList<Map<String,String>> secDomAuthenOpts = new ArrayList<Map<String, String>>();
        ArrayList<String> secDomAuthorCode = new ArrayList<String>();
        ArrayList<String> secDomAuthorFlag = new ArrayList<String>();
        ArrayList<Map<String,String>> secDomAuthorOpts = new ArrayList<Map<String, String>>();
        ArrayList<String> secDomMappingCode = new ArrayList<String>();
        ArrayList<String> secDomMappingType = new ArrayList<String>();
        ArrayList<Map<String,String>> secDomMappingOpts = new ArrayList<Map<String, String>>();
        String secDomName = idata.getVariable("securitydomain.name.variable");
        String secDomCache = idata.getVariable("securitydomain.cachetype.variable");

        //onComma will split all the key,value pairs by commas. Ignores commas encapsulated in quotes
        //onEqual will split the keys from values by an equal sign. Ignores equal signs encapsulated in quotes
        String onComma = "[,](?=([^\"]*\"[^\"]*\")*[^\"]*$)";
        String onEqual = "[=](?=([^\"]*\"[^\"]*\")*[^\"]*$)";

        //Name is the name of your option
        //Value is the value of your option, and this part does not like quotes, it breaks things
        //  Although single quotes are okay.


        if(idata.getRules().isConditionTrue("securitydomain.add.authen")) {
            for (int i = 1; i <= Integer.parseInt(idata.getVariable("securitydomain.add.authen" + UserInputPanel.DYNAMIC_FIELD_COMPONENT_NUM_ENDING)); i++) { //This is bad why are you dividing by three?
                secDomAuthenCode.add(idata.getVariable("securitydomain.add.authen-" + i + "-code"));
                secDomAuthenFlag.add(idata.getVariable("securitydomain.add.authen-" + i + "-flag"));
                Map secDomAuthenOptsMap = new HashMap<String, String>();


                String authenOpt = idata.getVariable("securitydomain.add.authen-" + i + "-operation");
                if (authenOpt != null) {
                    String[] authenOpts = authenOpt.split(onComma);
                    for (String opt : authenOpts) {
                        String[] option = opt.split(onEqual);
                        String name = option[0];
                        String value = option[1].replaceAll("\"", "");
                        secDomAuthenOptsMap.put(name, value);
                        // parsing
                    }
                }
                secDomAuthenOpts.add(secDomAuthenOptsMap);
            }
        }

        if (idata.getRules().isConditionTrue("securitydomain.add.author")) {
            for (int i = 1; i <= Integer.parseInt(idata.getVariable("securitydomain.add.author" + UserInputPanel.DYNAMIC_FIELD_COMPONENT_NUM_ENDING)); i++) {
                secDomAuthorCode.add(idata.getVariable("securitydomain.add.author-" + i + "-code"));
                secDomAuthorFlag.add(idata.getVariable("securitydomain.add.author-" + i + "-flag"));
                Map secDomAuthorOptsMap = new HashMap<String, String>(1);

                String authorOpt = idata.getVariable("securitydomain.add.author-" + i + "-operation");
                if (authorOpt != null) {
                    String[] authorOpts = authorOpt.split(onComma);
                    for (String opt : authorOpts) {
                        String[] option = opt.split(onEqual);
                        String name = option[0];
                        String value = option[1].replaceAll("\"", "");
                        secDomAuthorOptsMap.put(name, value); // hacky, but good enough for now
                    }
                }
                secDomAuthorOpts.add(secDomAuthorOptsMap);
            }
        }

        if (idata.getRules().isConditionTrue("securitydomain.add.mapping")) {
            for (int i = 1; i <= Integer.parseInt(idata.getVariable("securitydomain.add.mapping" + UserInputPanel.DYNAMIC_FIELD_COMPONENT_NUM_ENDING)); i++) {
                secDomMappingCode.add(idata.getVariable("securitydomain.add.mapping-" + i + "-code"));
                secDomMappingType.add(idata.getVariable("securitydomain.add.mapping-" + i + "-flag"));
                Map secDomMappingOptsMap = new HashMap<String, String>(1);

                String mappingOpt = idata.getVariable("securitydomain.add.mapping-" + i + "-operation");
                if (mappingOpt != null) {
                    String[] mappingOpts = mappingOpt.split(onComma);
                    for (String opt : mappingOpts) {
                        String[] option = opt.split(onEqual);
                        String name = option[0];
                        String value = option[1].replaceAll("\"", "");
                        secDomMappingOptsMap.put(name, value); // hacky, but good, enough for now
                    }
                }
                secDomMappingOpts.add(secDomMappingOptsMap);
            }
        }


        Map<String,String> secDomJsseAttrs = null;
        Map<String,String> secDomJsseKeystoreAttrs = null;
        Map<String,String> secDomJsseKeystoreManagerAttrs = null;
        Map<String,String> secDomJsseTruststoreAttrs = null;
        Map<String,String> secDomJsseTruststoreManagerAttrs = null;
        Map<String,String> secDomJsseAdditionalProps = null;


        //Only configure JSSE attributes if the JSSE checkbox is checked
        if (Boolean.parseBoolean(idata.getVariable("securityDomainAddJsse"))) {
            // check the other checkboxes
            boolean installKeystore = Boolean.parseBoolean(idata.getVariable("securityDomainJsseAddKeystore"));
            boolean installKeystoreManager = Boolean.parseBoolean(idata.getVariable("securityDomainJsseAddKeystoreManager"));
            boolean installTruststore = Boolean.parseBoolean(idata.getVariable("securityDomainJsseAddTruststore"));
            boolean installTruststoreManager = Boolean.parseBoolean(idata.getVariable("securityDomainJsseAddTruststoreManager"));


            String ciphersuites = idata.getVariable("securitydomain.jsse.ciphersuites");
            String protocols = idata.getVariable("securitydomain.jsse.protocols");
            String clientalias = idata.getVariable("securitydomain.jsse.client-alias");
            String serveralias = idata.getVariable("securitydomain.jsse.server-alias");
            String authtoken = idata.getVariable("securitydomain.jsse.authtoken");

            //We should pick a standard for checkboxes such that true alaways "true" false always "false"
            // We can accept empty values here, but not null ones


            if (ciphersuites != null || protocols != null || clientalias != null || serveralias != null || authtoken != null) {
                secDomJsseAttrs = new HashMap<String, String>();
                secDomJsseAttrs.put("cipher-suites", ciphersuites);
                secDomJsseAttrs.put("protocols", protocols);
                secDomJsseAttrs.put("client-alias", clientalias);
                secDomJsseAttrs.put("server-alias", serveralias);
                secDomJsseAttrs.put("service-auth-token", authtoken);
            }

            if (installKeystore) {
                secDomJsseKeystoreAttrs = new HashMap<String, String>();
                secDomJsseKeystoreAttrs.put("password", idata.getVariable("securitydomain.jsse.keystore.password"));
                secDomJsseKeystoreAttrs.put("provider", idata.getVariable("securitydomain.jsse.keystore.provider"));
                secDomJsseKeystoreAttrs.put("provider-argument", idata.getVariable("securitydomain.jsse.keystore.providerargument"));
                secDomJsseKeystoreAttrs.put("type", idata.getVariable("securitydomain.jsse.keystore.type"));
                secDomJsseKeystoreAttrs.put("url", idata.getVariable("securitydomain.jsse.keystore.url"));
            }

            if (installKeystoreManager) {
                secDomJsseKeystoreManagerAttrs = new HashMap<String, String>();
                secDomJsseKeystoreManagerAttrs.put("algorithm", idata.getVariable("securitydomain.jsse.keystoremanager.algorithm"));
                secDomJsseKeystoreManagerAttrs.put("provider", idata.getVariable("securitydomain.jsse.keystoremanager.provider"));
            }

            if (installTruststore) {
                secDomJsseTruststoreAttrs = new HashMap<String, String>();
                secDomJsseTruststoreAttrs.put("password", idata.getVariable("securitydomain.jsse.truststore.password"));
                secDomJsseTruststoreAttrs.put("provider", idata.getVariable("securitydomain.jsse.truststore.provider"));
                secDomJsseTruststoreAttrs.put("provider-argument", idata.getVariable("securitydomain.jsse.truststore.providerargument"));
                secDomJsseTruststoreAttrs.put("type", idata.getVariable("securitydomain.jsse.truststore.type"));
                secDomJsseTruststoreAttrs.put("url", idata.getVariable("securitydomain.jsse.truststore.url"));
            }

            if (installTruststoreManager) {
                secDomJsseTruststoreManagerAttrs = new HashMap<String, String>();
                secDomJsseTruststoreManagerAttrs.put("algorithm", idata.getVariable("securitydomain.jsse.truststoremanager.algorithm"));
                secDomJsseTruststoreManagerAttrs.put("provider", idata.getVariable("securitydomain.jsse.truststoremanager.provider"));
            }
        }
        boolean result = serverCommands.addSecurityDomain(secDomName, secDomCache, secDomAuthenCode, secDomAuthenFlag, secDomAuthenOpts, secDomAuthorCode, secDomAuthorFlag, secDomAuthorOpts, secDomMappingCode,
                secDomMappingType, secDomMappingOpts, secDomJsseAttrs, secDomJsseKeystoreAttrs, secDomJsseKeystoreManagerAttrs, secDomJsseTruststoreAttrs, secDomJsseTruststoreManagerAttrs,
                secDomJsseAdditionalProps);
        if (!result){
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.securitydomain.install.error"), true);
        } else{
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.securitydomain.install.success"), false);
        }
        return result;
    }
}
