package com.redhat.installer.installation.validator;

import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.panels.ProcessingClient;
import java.io.File;

/**
 *  Responsible for ensuring that the given path input is a file, and not a folder.
 * Created by mvaghela on 05/04/16.
 */
public class IsFileValidator implements Validator {
    public Status validate(ProcessingClient client)
    {
        Status failureStatus = Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get(WARNING_PARAM)))
            failureStatus = Status.WARNING;
        String path = client.getFieldContents(0);
        File file = new File(path);
        if (file.exists() && file.isDirectory())
        {
            return failureStatus;
        }
        return Status.OK;
    }
}
