/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.auth.Subject;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.AbstractIscDbHandle;
import org.firebirdsql.gds.impl.GDSServerVersion;
import org.firebirdsql.gds.impl.jni.isc_tr_handle_impl;

public final class isc_db_handle_impl
extends AbstractIscDbHandle {
    private int rdb_id;
    private int rdb_id_ptr = 0;
    private Subject subject;
    private Collection rdb_transactions = new ArrayList();
    private List rdb_warnings = new ArrayList();
    private boolean invalid;
    private int resp_object;
    private long resp_blob_id;
    private byte[] resp_data;
    private int dialect = 0;
    private int protocol = 0;
    private String version = null;
    private GDSServerVersion serverVersion;
    private int ODSMajorVersion = 0;
    private int ODSMinorVersion = 0;

    public boolean isValid() {
        return !this.invalid;
    }

    void invalidate() {
        this.invalid = true;
    }

    void setRdbId(int rdb_id) {
        this.checkValidity();
        this.rdb_id = rdb_id;
    }

    public int getRdbId() {
        this.checkValidity();
        return this.rdb_id;
    }

    void setRdb_id_ptr(int rdb_id_ptr, int value) {
        this.setRdbId(value);
        this.rdb_id_ptr = rdb_id_ptr;
    }

    public int getRdb_id_ptr() {
        return this.rdb_id_ptr;
    }

    void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public boolean hasTransactions() {
        this.checkValidity();
        return !this.rdb_transactions.isEmpty();
    }

    int getOpenTransactionCount() {
        this.checkValidity();
        return this.rdb_transactions.size();
    }

    void addTransaction(isc_tr_handle_impl tr) {
        this.checkValidity();
        this.rdb_transactions.add(tr);
    }

    void removeTransaction(isc_tr_handle_impl tr) {
        this.checkValidity();
        this.rdb_transactions.remove(tr);
    }

    public Collection getTransactions() {
        return new ArrayList(this.rdb_transactions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWarnings() {
        this.checkValidity();
        List list = this.rdb_warnings;
        synchronized (list) {
            return new ArrayList(this.rdb_warnings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWarning(GDSException warning) {
        this.checkValidity();
        List list = this.rdb_warnings;
        synchronized (list) {
            this.rdb_warnings.add(warning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() {
        this.checkValidity();
        List list = this.rdb_warnings;
        synchronized (list) {
            this.rdb_warnings.clear();
        }
    }

    public void setDialect(int value) {
        this.dialect = value;
    }

    public int getDialect() {
        return this.dialect;
    }

    public void setProtocol(int value) {
        this.protocol = value;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setVersion(String value) throws GDSException {
        this.version = value;
        this.serverVersion = new GDSServerVersion(this.version);
    }

    public String getVersion() {
        return this.version;
    }

    public String getDatabaseProductName() {
        return this.serverVersion.getServerName();
    }

    public String getDatabaseProductVersion() {
        return this.version;
    }

    public int getDatabaseProductMajorVersion() {
        return this.serverVersion.getMajorVersion();
    }

    public int getDatabaseProductMinorVersion() {
        return this.serverVersion.getMinorVersion();
    }

    public void setODSMajorVersion(int value) {
        this.ODSMajorVersion = value;
    }

    public int getODSMajorVersion() {
        return this.ODSMajorVersion;
    }

    public void setODSMinorVersion(int value) {
        this.ODSMinorVersion = value;
    }

    public int getODSMinorVersion() {
        return this.ODSMinorVersion;
    }

    public void setResp_object(int value) {
        this.resp_object = value;
    }

    public int getResp_object() {
        return this.resp_object;
    }

    public void setResp_blob_id(long value) {
        this.resp_blob_id = value;
    }

    public long getResp_blob_id() {
        return this.resp_blob_id;
    }

    public void setResp_data(byte[] value) {
        this.resp_data = value;
    }

    public byte[] getResp_data() {
        return this.resp_data;
    }

    private void checkValidity() {
        if (this.invalid) {
            throw new IllegalStateException("This database handle is invalid and cannot be used anymore.");
        }
    }
}

