/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSetNotUpdatableException;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdRowUpdater;
import org.firebirdsql.jdbc.Synchronizable;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public class FBRowUpdater
implements FirebirdRowUpdater {
    private static final int PARAMETER_UNUSED = 0;
    private static final int PARAMETER_USED = 1;
    private static final int PARAMETER_DBKEY = 2;
    private GDSHelper gdsHelper;
    private Synchronizable syncProvider;
    private XSQLVAR[] xsqlvars;
    private FBField[] fields;
    private boolean inInsertRow;
    private byte[][] newRow;
    private byte[][] oldRow;
    private byte[][] insertRow;
    private boolean[] updatedFlags;
    private String tableName;
    private AbstractIscStmtHandle updateStatement;
    private AbstractIscStmtHandle deleteStatement;
    private AbstractIscStmtHandle insertStatement;
    private AbstractIscStmtHandle selectStatement;
    private FBObjectListener.ResultSetListener rsListener;
    private boolean closed;
    private boolean processing;
    private static final int UPDATE_STATEMENT_TYPE = 1;
    private static final int DELETE_STATEMENT_TYPE = 2;
    private static final int INSERT_STATEMENT_TYPE = 3;
    private static final int SELECT_STATEMENT_TYPE = 4;

    public FBRowUpdater(GDSHelper connection, XSQLVAR[] xsqlvars, Synchronizable syncProvider, boolean cached, FBObjectListener.ResultSetListener rsListener) throws SQLException {
        int i;
        this.rsListener = rsListener;
        this.gdsHelper = connection;
        this.syncProvider = syncProvider;
        this.xsqlvars = new XSQLVAR[xsqlvars.length];
        this.fields = new FBField[xsqlvars.length];
        for (i = 0; i < xsqlvars.length; ++i) {
            XSQLVAR xsqlvar;
            this.xsqlvars[i] = xsqlvar = xsqlvars[i].deepCopy();
        }
        this.newRow = new byte[xsqlvars.length][];
        this.updatedFlags = new boolean[xsqlvars.length];
        for (i = 0; i < this.xsqlvars.length; ++i) {
            final int fieldPos = i;
            FieldDataProvider dataProvider = new FieldDataProvider(){

                public byte[] getFieldData() {
                    if (FBRowUpdater.this.updatedFlags[fieldPos]) {
                        if (FBRowUpdater.this.inInsertRow) {
                            return FBRowUpdater.this.insertRow[fieldPos];
                        }
                        return FBRowUpdater.this.newRow[fieldPos];
                    }
                    return FBRowUpdater.this.oldRow[fieldPos];
                }

                public void setFieldData(byte[] data) {
                    if (FBRowUpdater.this.inInsertRow) {
                        ((FBRowUpdater)FBRowUpdater.this).insertRow[fieldPos] = data;
                    } else {
                        ((FBRowUpdater)FBRowUpdater.this).newRow[fieldPos] = data;
                    }
                    ((FBRowUpdater)FBRowUpdater.this).updatedFlags[fieldPos] = true;
                }
            };
            this.fields[i] = FBField.createField(this.xsqlvars[i], dataProvider, connection, cached);
        }
        for (i = 0; i < xsqlvars.length; ++i) {
            if (this.tableName == null) {
                this.tableName = xsqlvars[i].relname;
                continue;
            }
            if (this.tableName.equals(xsqlvars[i].relname)) continue;
            throw new FBResultSetNotUpdatableException("Underlying result set references at least two relations: " + this.tableName + " and " + xsqlvars[i].relname + ".");
        }
    }

    private void notifyExecutionStarted() throws SQLException {
        if (this.closed) {
            throw new FBSQLException("Corresponding result set is closed.");
        }
        if (this.processing) {
            return;
        }
        this.rsListener.executionStarted(this);
        this.processing = true;
    }

    private void notifyExecutionCompleted(boolean success) throws SQLException {
        if (!this.processing) {
            return;
        }
        this.rsListener.executionCompleted(this, success);
        this.processing = false;
    }

    public void close() throws SQLException {
        this.closed = true;
        if (this.processing) {
            this.notifyExecutionCompleted(true);
        }
    }

    public void setRow(byte[][] row) {
        this.oldRow = row;
        this.updatedFlags = new boolean[this.xsqlvars.length];
        this.inInsertRow = false;
    }

    public void cancelRowUpdates() {
        this.newRow = new byte[this.xsqlvars.length][];
        this.updatedFlags = new boolean[this.xsqlvars.length];
        this.inInsertRow = false;
    }

    public FBField getField(int fieldPosition) {
        return this.fields[fieldPosition];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getParameterMask() throws SQLException {
        FBDatabaseMetaData metaData = new FBDatabaseMetaData(this.gdsHelper);
        ResultSet bestRowIdentifier = metaData.getBestRowIdentifier("", "", this.tableName, 2, true);
        try {
            int[] result = new int[this.xsqlvars.length];
            boolean hasParams = false;
            while (bestRowIdentifier.next()) {
                String columnName = bestRowIdentifier.getString(2);
                if (columnName == null) continue;
                boolean found = false;
                for (int i = 0; i < this.xsqlvars.length; ++i) {
                    if ("RDB$DB_KEY".equals(columnName) && "DB_KEY".equals(this.xsqlvars[i].sqlname)) {
                        result[i] = 2;
                        found = true;
                        continue;
                    }
                    if (columnName.equals(this.xsqlvars[i].sqlname)) {
                        result[i] = 1;
                        found = true;
                        continue;
                    }
                    result[i] = 0;
                }
                if (!found) {
                    throw new FBResultSetNotUpdatableException("Underlying result set does not contain all columns that form 'best row identifier'.");
                }
                hasParams = true;
            }
            if (!hasParams) {
                throw new FBResultSetNotUpdatableException("No columns that can be used in WHERE clause could be found.");
            }
            int[] nArray = result;
            return nArray;
        }
        finally {
            bestRowIdentifier.close();
        }
    }

    private void appendWhereClause(StringBuffer sb, int[] parameterMask) {
        sb.append("WHERE");
        sb.append("\n");
        boolean hasDbKey = false;
        for (int i = 0; i < parameterMask.length; ++i) {
            if (parameterMask[i] != 2) continue;
            hasDbKey = true;
        }
        if (hasDbKey) {
            sb.append("RDB$DB_KEY = ?");
            return;
        }
        boolean first = true;
        for (int i = 0; i < this.xsqlvars.length; ++i) {
            if (parameterMask[i] == 0) continue;
            if (!first) {
                sb.append("AND");
            }
            sb.append("\n\t");
            sb.append(this.xsqlvars[i].sqlname).append(" = ").append("?");
            first = false;
        }
    }

    private String buildUpdateStatement(int[] parameterMask) {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ").append(this.tableName).append("\n");
        sb.append("SET").append("\n");
        boolean first = true;
        for (int i = 0; i < this.xsqlvars.length; ++i) {
            if (!this.updatedFlags[i]) continue;
            if (!first) {
                sb.append(",");
            }
            sb.append("\n\t");
            sb.append(this.xsqlvars[i].sqlname).append(" = ").append("?");
            first = false;
        }
        sb.append("\n");
        this.appendWhereClause(sb, parameterMask);
        return sb.toString();
    }

    private String buildDeleteStatement(int[] parameterMask) {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM ").append(this.tableName).append("\n");
        this.appendWhereClause(sb, parameterMask);
        return sb.toString();
    }

    private String buildInsertStatement() {
        StringBuffer sb = new StringBuffer();
        StringBuffer columns = new StringBuffer();
        StringBuffer params = new StringBuffer();
        sb.append("INSERT INTO ").append(this.tableName);
        boolean first = true;
        for (int i = 0; i < this.xsqlvars.length; ++i) {
            if (!this.updatedFlags[i]) continue;
            if (!first) {
                columns.append(", ");
                params.append(", ");
            }
            columns.append(this.xsqlvars[i].sqlname);
            params.append("?");
            first = false;
        }
        sb.append("(\n\t").append(columns).append("\n)");
        sb.append("VALUES");
        sb.append("(\n\t").append(params).append("\n)");
        return sb.toString();
    }

    private String buildSelectStatement(int[] parameterMask) {
        StringBuffer sb = new StringBuffer();
        StringBuffer columns = new StringBuffer();
        sb.append("SELECT");
        boolean first = true;
        for (int i = 0; i < this.xsqlvars.length; ++i) {
            if (!first) {
                columns.append(", ");
            }
            columns.append(this.xsqlvars[i].sqlname);
            first = false;
        }
        sb.append("\n\t").append(columns).append("\n");
        sb.append("FROM");
        sb.append("\n\t").append(this.tableName).append("\n");
        this.appendWhereClause(sb, parameterMask);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        Object mutex;
        boolean success = false;
        Object object = mutex = this.syncProvider.getSynchronizationObject();
        synchronized (object) {
            try {
                this.notifyExecutionStarted();
                if (this.updateStatement == null) {
                    this.updateStatement = this.gdsHelper.allocateStatement();
                }
                this.executeStatement(1, this.updateStatement);
                success = true;
            }
            catch (GDSException ex) {
                throw new FBSQLException(ex);
            }
            finally {
                this.notifyExecutionCompleted(success);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        Object mutex;
        boolean success = false;
        Object object = mutex = this.syncProvider.getSynchronizationObject();
        synchronized (object) {
            try {
                this.notifyExecutionStarted();
                if (this.deleteStatement == null) {
                    this.deleteStatement = this.gdsHelper.allocateStatement();
                }
                this.executeStatement(2, this.deleteStatement);
                success = true;
            }
            catch (GDSException ex) {
                throw new FBSQLException(ex);
            }
            finally {
                this.notifyExecutionCompleted(success);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        Object mutex;
        boolean success = false;
        Object object = mutex = this.syncProvider.getSynchronizationObject();
        synchronized (object) {
            try {
                this.notifyExecutionStarted();
                if (this.insertStatement == null) {
                    this.insertStatement = this.gdsHelper.allocateStatement();
                }
                this.executeStatement(3, this.insertStatement);
                success = true;
            }
            catch (GDSException ex) {
                throw new FBSQLException(ex);
            }
            finally {
                this.notifyExecutionCompleted(success);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        Object mutex;
        boolean success = false;
        Object object = mutex = this.syncProvider.getSynchronizationObject();
        synchronized (object) {
            try {
                this.notifyExecutionStarted();
                if (this.selectStatement == null) {
                    this.selectStatement = this.gdsHelper.allocateStatement();
                }
                this.executeStatement(4, this.selectStatement);
                try {
                    this.gdsHelper.fetch(this.selectStatement, 10);
                    byte[][][] rows = this.selectStatement.getRows();
                    if (this.selectStatement.size() == 0) {
                        throw new FBSQLException("No rows could be fetched.");
                    }
                    if (this.selectStatement.size() > 1) {
                        throw new FBSQLException("More then one row fetched.");
                    }
                    this.setRow(rows[0]);
                }
                finally {
                    this.gdsHelper.closeStatement(this.selectStatement, false);
                }
                success = true;
            }
            catch (GDSException ex) {
                throw new FBSQLException(ex);
            }
            finally {
                this.notifyExecutionCompleted(success);
            }
        }
    }

    private void executeStatement(int statementType, AbstractIscStmtHandle stmt) throws SQLException {
        try {
            int i;
            String sql;
            if (!stmt.isValid()) {
                throw new FBSQLException("Corresponding connection is not valid.", "08007");
            }
            if (this.inInsertRow && statementType != 3) {
                throw new FBSQLException("Only insertRow() is allowed when result set is positioned on insert row.");
            }
            if (statementType != 3 && this.oldRow == null) {
                throw new FBSQLException("Result set is not positioned on a row.");
            }
            for (int i2 = 0; i2 < this.xsqlvars.length; ++i2) {
                if (!(this.fields[i2] instanceof FBFlushableField)) continue;
                ((FBFlushableField)((Object)this.fields[i2])).flushCachedData();
            }
            int[] parameterMask = this.getParameterMask();
            switch (statementType) {
                case 1: {
                    sql = this.buildUpdateStatement(parameterMask);
                    break;
                }
                case 2: {
                    sql = this.buildDeleteStatement(parameterMask);
                    break;
                }
                case 3: {
                    sql = this.buildInsertStatement();
                    break;
                }
                case 4: {
                    sql = this.buildSelectStatement(parameterMask);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect statement type specified.");
                }
            }
            this.gdsHelper.prepareStatement(stmt, sql, true);
            XSQLVAR[] params = stmt.getInSqlda().sqlvar;
            int paramIterator = 0;
            if (statementType == 1) {
                for (i = 0; i < this.xsqlvars.length; ++i) {
                    if (!this.updatedFlags[i]) continue;
                    params[paramIterator].copyFrom(this.xsqlvars[i]);
                    params[paramIterator].sqldata = this.newRow[i];
                    ++paramIterator;
                }
            }
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (parameterMask[i] == 0 && statementType != 3 || !this.updatedFlags[i] && statementType == 3) continue;
                params[paramIterator].copyFrom(this.xsqlvars[i]);
                params[paramIterator].sqldata = statementType == 3 ? this.insertRow[i] : this.oldRow[i];
                ++paramIterator;
            }
            this.gdsHelper.executeStatement(stmt, false);
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public byte[][] getNewRow() {
        byte[][] result = new byte[this.oldRow.length][];
        for (int i = 0; i < result.length; ++i) {
            if (this.updatedFlags[i]) {
                if (this.newRow[i] == null) {
                    result[i] = null;
                    continue;
                }
                result[i] = new byte[this.newRow[i].length];
                System.arraycopy(this.newRow[i], 0, result[i], 0, this.newRow[i].length);
                continue;
            }
            if (this.oldRow[i] == null) {
                result[i] = null;
                continue;
            }
            result[i] = new byte[this.oldRow[i].length];
            System.arraycopy(this.oldRow[i], 0, result[i], 0, this.oldRow[i].length);
        }
        return result;
    }

    public byte[][] getInsertRow() {
        return this.insertRow;
    }

    public byte[][] getOldRow() {
        return this.oldRow;
    }

    public void moveToInsertRow() throws SQLException {
        this.inInsertRow = true;
        this.insertRow = new byte[this.xsqlvars.length][];
        this.updatedFlags = new boolean[this.xsqlvars.length];
    }

    public void moveToCurrentRow() throws SQLException {
        this.inInsertRow = false;
        this.insertRow = new byte[this.xsqlvars.length][];
        this.updatedFlags = new boolean[this.xsqlvars.length];
    }
}

