/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionItem;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.FetchChunk;
import com.sap.dbtech.jdbc.FetchInfo;
import com.sap.dbtech.jdbc.ResultSetMetaDataSapDB;
import com.sap.dbtech.jdbc.StatementSapDB;
import com.sap.dbtech.jdbc.exceptions.InternalJDBCError;
import com.sap.dbtech.jdbc.exceptions.InvalidArgumentValue;
import com.sap.dbtech.jdbc.exceptions.InvalidColumnException;
import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.exceptions.NotImplemented;
import com.sap.dbtech.jdbc.exceptions.NotSupportedException;
import com.sap.dbtech.jdbc.exceptions.ObjectIsClosedException;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.PartNotFound;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class ResultSetSapDB
extends ConnectionItem
implements ResultSet,
SQLParamController {
    public static final int DEFAULT_FETCHSIZE = 30000;
    protected static final int POSITION_BEFORE_FIRST = 1;
    protected static final int POSITION_INSIDE = 2;
    protected static final int POSITION_AFTER_LAST = 3;
    protected static final int POSITION_NOT_AVAILABLE = 4;
    private FetchInfo fetchInfo;
    private StatementSapDB statement;
    private int fetchSize;
    private int maxRows;
    private FetchChunk currentChunk;
    protected int positionState;
    private int positionStateOfChunk;
    private boolean fromMetaData;
    private boolean lastWasNull;
    private boolean isClosed;
    private boolean empty;
    private int fetchDirection;
    private Vector openStreams;
    private int rowsInResultSet;
    private int safeFetchSize;
    private boolean safeFetchSizeDetermined;
    private int largestKnownAbsPos;
    private int maxRowsOutSideResult;
    protected int modifiedKernelPos;
    private int cursorType;

    ResultSetSapDB(ConnectionSapDB connectionSapDB, FetchInfo fetchInfo, StatementSapDB statementSapDB, int n, int n2, int n3, ReplyPacket replyPacket) throws SQLException {
        super(connectionSapDB);
        this.fetchInfo = fetchInfo;
        this.statement = statementSapDB;
        this.fetchSize = n >= 1 ? n : 30000;
        this.maxRows = n2;
        this.isClosed = false;
        this.fetchDirection = 1000;
        this.initializeFields();
        this.openStreams = new Vector(5);
        this.cursorType = n3;
        if (replyPacket != null) {
            this.setCurrentChunk(new FetchChunk(1, 1, replyPacket, fetchInfo.getRecordSize(), n2, this.rowsInResultSet));
            this.positionState = 1;
        }
    }

    protected void initializeFields() {
        this.currentChunk = null;
        this.positionState = 1;
        this.positionStateOfChunk = 4;
        this.empty = false;
        this.safeFetchSize = 1;
        this.safeFetchSizeDetermined = false;
        this.largestKnownAbsPos = 1;
        this.maxRowsOutSideResult = 0;
        this.rowsInResultSet = -1;
        this.modifiedKernelPos = 0;
    }

    ResultSetSapDB(ConnectionSapDB connectionSapDB, String string, DBTechTranslator[] dBTechTranslatorArray, String[] stringArray, StatementSapDB statementSapDB, int n, int n2, int n3, ReplyPacket replyPacket) throws SQLException {
        this(connectionSapDB, new FetchInfo(connectionSapDB, string, dBTechTranslatorArray, stringArray, statementSapDB.isPacketEncodingUnicode()), statementSapDB, n, n2, n3, replyPacket);
    }

    public boolean absolute(int n) throws SQLException {
        return this.absolute(n, false);
    }

    public boolean absolute(int n, boolean bl) throws SQLException {
        this.clearWarnings();
        this.assertNotClosed();
        this.assertNotForwardOnly();
        if (n == 0) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.row.isnull"), "21000");
        }
        if (this.empty) {
            if (n > 0) {
                this.positionState = 3;
                return false;
            }
            this.positionState = 1;
            return false;
        }
        if (n > 0) {
            if (this.maxRowIsSet() && n > this.maxRows) {
                this.positionState = 3;
                return false;
            }
            if (this.rowsInResultSetKnown() && n > this.rowsInResultSet) {
                this.positionState = 3;
                return false;
            }
            if (this.positionStateOfChunk != 2) {
                boolean bl2 = this.fetchAbsoluteUp(n, bl);
                if (!bl2) {
                    this.positionState = 3;
                }
                return bl2;
            }
            if (this.currentChunk.setRow(n)) {
                this.positionState = 2;
                return true;
            }
            boolean bl3 = this.fetchAbsoluteUp(n, bl);
            if (!bl3) {
                this.positionState = 3;
            }
            return bl3;
        }
        if (this.rowsInResultSetKnown()) {
            int n2 = this.invertPosition(n);
            if (n2 <= 0) {
                this.positionState = 1;
                return false;
            }
            return this.absolute(n2);
        }
        if (this.maxRowIsSet() && -n > this.maxRows) {
            this.positionState = 1;
            return false;
        }
        if (this.positionStateOfChunk != 2) {
            boolean bl4 = this.fetchAbsoluteDown(n);
            if (!bl4) {
                this.positionState = 1;
            }
            return bl4;
        }
        if (this.currentChunk.setRow(n)) {
            this.positionState = 2;
            return true;
        }
        boolean bl5 = this.fetchAbsoluteDown(n);
        if (!bl5) {
            this.positionState = 1;
        }
        return bl5;
    }

    public boolean next() throws SQLException {
        this.clearWarnings();
        this.assertNotClosed();
        if (this.empty) {
            this.positionState = 3;
            return false;
        }
        boolean bl = false;
        this.closeOpenStreams();
        if (this.positionState == 1) {
            if (this.positionStateOfChunk == 2 && this.currentChunk.containsRow(1)) {
                this.currentChunk.setRow(1);
                this.positionState = 2;
                bl = true;
            } else {
                bl = this.fetchFirst();
            }
        } else if (this.positionState == 2) {
            if (this.currentChunk.move(1)) {
                bl = true;
            } else {
                if (this.currentChunk.isLast()) {
                    this.positionState = 3;
                    return false;
                }
                bl = this.fetchNextChunk();
            }
        } else if (this.positionState == 3) {
            // empty if block
        }
        if (bl) {
            this.clearWarnings();
        }
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        return this.relative(n, true);
    }

    public boolean relative(int n, boolean bl) throws SQLException {
        this.clearWarnings();
        this.assertNotClosed();
        this.assertNotForwardOnly();
        if (this.empty) {
            if (bl) {
                throw new JDBCDriverException(MessageTranslator.translate("warning.emptyresultset"));
            }
            return false;
        }
        if (this.positionState != 2) {
            if (bl) {
                if (this.positionState == 1) {
                    throw new JDBCDriverException(MessageTranslator.translate("error.resultset.beforefirst"));
                }
                throw new JDBCDriverException(MessageTranslator.translate("error.resultset.afterlast"));
            }
            return false;
        }
        int n2 = this.getInternalRow();
        if (n2 > 0) {
            if (n2 + n <= 0) {
                this.positionState = 1;
                return false;
            }
            return this.absolute(n2 + n, n < 0);
        }
        if (n2 + n >= 0) {
            this.positionState = 3;
            return false;
        }
        return this.absolute(n2 + n, n < 0);
    }

    public boolean previous() throws SQLException {
        this.clearWarnings();
        this.assertNotClosed();
        if (this.positionState == 3) {
            return this.absolute(-1);
        }
        return this.relative(-1, false);
    }

    public boolean first() throws SQLException {
        this.clearWarnings();
        this.assertNotClosed();
        this.assertNotForwardOnly();
        if (this.empty) {
            this.positionState = 3;
            return false;
        }
        this.closeOpenStreams();
        boolean bl = false;
        if (this.positionStateOfChunk == 2 && this.currentChunk.containsRow(1)) {
            this.currentChunk.setRow(1);
            this.positionState = 2;
            bl = true;
        } else {
            bl = this.fetchFirst();
        }
        if (bl) {
            this.clearWarnings();
        }
        return bl;
    }

    public boolean last() throws SQLException {
        this.clearWarnings();
        this.assertNotClosed();
        this.assertNotForwardOnly();
        if (this.empty) {
            this.positionState = 3;
            return false;
        }
        this.closeOpenStreams();
        boolean bl = false;
        if (this.positionStateOfChunk == 2 && this.currentChunk.setRow(-1)) {
            this.positionState = 2;
            bl = true;
        } else {
            bl = this.fetchLast();
        }
        if (bl) {
            this.clearWarnings();
        }
        return bl;
    }

    public void afterLast() throws SQLException {
        this.assertNotForwardOnly();
        this.assertNotClosed();
        this.positionState = 3;
    }

    public void beforeFirst() throws SQLException {
        this.clearWarnings();
        this.assertNotForwardOnly();
        this.assertNotClosed();
        this.positionState = 1;
    }

    public boolean isFirst() throws SQLException {
        this.assertNotClosed();
        return this.currentChunk != null && !this.empty && this.currentChunk.isFirst() && this.currentChunk.isAtLowerBound();
    }

    public boolean isLast() throws SQLException {
        this.assertNotClosed();
        return this.currentChunk != null && !this.empty && this.currentChunk.isLast() && this.currentChunk.isAtUpperBound();
    }

    public boolean isBeforeFirst() throws SQLException {
        this.assertNotClosed();
        return !this.empty && this.positionState == 1;
    }

    public boolean isAfterLast() throws SQLException {
        this.assertNotClosed();
        return !this.empty && this.positionState == 3;
    }

    public boolean wasNull() throws SQLException {
        this.assertNotClosed();
        return this.lastWasNull;
    }

    public void close() throws SQLException {
        this.close(false);
    }

    public void close(boolean bl) throws SQLException {
        this.clearWarnings();
        if (this.fetchInfo != null) {
            if (!(this.cursorType != 5 || this.currentChunk != null && this.currentChunk.isLast())) {
                this.cursorType = 1;
            }
            if (!(bl || this.cursorType != 1 && this.cursorType != 4)) {
                this.connection.dropCursor(this.fetchInfo.getCursorName());
            }
        }
        this.cursorType = 0;
        this.isClosed = true;
        this.currentChunk = null;
        this.fetchInfo = null;
    }

    public int findColumn(String string) throws SQLException {
        this.assertNotClosed();
        return this.findColumnInfo(string).getColIndex() + 1;
    }

    public Array getArray(int n) throws SQLException {
        throw new NotSupportedException(MessageTranslator.translate("error.array.unsupported"), this);
    }

    public Array getArray(String string) throws SQLException {
        throw new NotSupportedException(MessageTranslator.translate("error.array.unsupported"), this);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream = this.findColumnInfo(n).getAsciiStream(this, this.getCurrentRecord(), this.getReplyData());
        if (inputStream != null) {
            this.openStreams.addElement(inputStream);
        }
        return inputStream;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        InputStream inputStream = this.findColumnInfo(string).getAsciiStream(this, this.getCurrentRecord(), this.getReplyData());
        if (inputStream != null) {
            this.openStreams.addElement(inputStream);
        }
        return inputStream;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.findColumnInfo(n).getBigDecimal(this, this.getCurrentRecord());
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.findColumnInfo(n).getBigDecimal(n2, this, this.getCurrentRecord());
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.findColumnInfo(string).getBigDecimal(this, this.getCurrentRecord());
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.findColumnInfo(string).getBigDecimal(n, this, this.getCurrentRecord());
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream = this.findColumnInfo(n).getBinaryStream(this, this.getCurrentRecord(), this.getReplyData());
        if (inputStream != null) {
            this.openStreams.addElement(inputStream);
        }
        return inputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        InputStream inputStream = this.findColumnInfo(string).getBinaryStream(this, this.getCurrentRecord(), this.getReplyData());
        if (inputStream != null) {
            this.openStreams.addElement(inputStream);
        }
        return inputStream;
    }

    public Blob getBlob(int n) throws SQLException {
        return this.findColumnInfo(n).getBlob(this, this.getCurrentRecord(), this.getReplyData());
    }

    public Blob getBlob(String string) throws SQLException {
        return this.findColumnInfo(string).getBlob(this, this.getCurrentRecord(), this.getReplyData());
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.findColumnInfo(n).getBoolean(this, this.getCurrentRecord());
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.findColumnInfo(string).getBoolean(this, this.getCurrentRecord());
    }

    public byte getByte(int n) throws SQLException {
        return this.findColumnInfo(n).getByte(this, this.getCurrentRecord());
    }

    public byte getByte(String string) throws SQLException {
        return this.findColumnInfo(string).getByte(this, this.getCurrentRecord());
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.findColumnInfo(n).getBytes(this, this.getCurrentRecord());
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.findColumnInfo(string).getBytes(this, this.getCurrentRecord());
    }

    public Reader getCharacterStream(int n) throws SQLException {
        Reader reader = this.findColumnInfo(n).getCharacterStream(this, this.getCurrentRecord(), this.getReplyData());
        if (reader != null) {
            this.openStreams.addElement(reader);
        }
        return reader;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        Reader reader = this.findColumnInfo(string).getCharacterStream(this, this.getCurrentRecord(), this.getReplyData());
        if (reader != null) {
            this.openStreams.addElement(reader);
        }
        return reader;
    }

    public Clob getClob(int n) throws SQLException {
        return this.findColumnInfo(n).getClob(this, this.getCurrentRecord(), this.getReplyData());
    }

    public Clob getClob(String string) throws SQLException {
        return this.findColumnInfo(string).getClob(this, this.getCurrentRecord(), this.getReplyData());
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public Date getDate(int n) throws SQLException {
        return this.findColumnInfo(n).getDate(this, this.getCurrentRecord(), null);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.findColumnInfo(n).getDate(this, this.getCurrentRecord(), calendar);
    }

    public Date getDate(String string) throws SQLException {
        return this.findColumnInfo(string).getDate(this, this.getCurrentRecord(), null);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.findColumnInfo(string).getDate(this, this.getCurrentRecord(), calendar);
    }

    public double getDouble(int n) throws SQLException {
        return this.findColumnInfo(n).getDouble(this, this.getCurrentRecord());
    }

    public double getDouble(String string) throws SQLException {
        return this.findColumnInfo(string).getDouble(this, this.getCurrentRecord());
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.assertNotClosed();
        switch (n) {
            case 1001: 
            case 1002: {
                this.assertNotForwardOnly();
            }
            case 1000: {
                this.fetchDirection = n;
                break;
            }
            default: {
                throw new InvalidArgumentValue("direction", "FETCH_FORWARD, FETCH_REVERSE, FETCH_UNKNOWN");
            }
        }
    }

    public int getFetchSize() throws SQLException {
        this.assertNotClosed();
        return this.fetchSize;
    }

    public void setFetchSize(int n) throws SQLException {
        this.assertNotClosed();
        if (n >= 0) {
            this.fetchSize = n;
            this.safeFetchSize = Math.min(this.safeFetchSize, n);
            if (this.safeFetchSize <= this.fetchSize && this.safeFetchSize != 1) {
                this.safeFetchSizeDetermined = true;
            }
        } else {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.invalid.fetchsize", Integer.toString(n)), "22003");
        }
    }

    public boolean rowUpdated() throws SQLException {
        this.assertNotClosed();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.assertNotClosed();
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.assertNotClosed();
        return false;
    }

    public float getFloat(int n) throws SQLException {
        return this.findColumnInfo(n).getFloat(this, this.getCurrentRecord());
    }

    public float getFloat(String string) throws SQLException {
        return this.findColumnInfo(string).getFloat(this, this.getCurrentRecord());
    }

    public int getInt(int n) throws SQLException {
        return this.findColumnInfo(n).getInt(this, this.getCurrentRecord());
    }

    public int getInt(String string) throws SQLException {
        return this.findColumnInfo(string).getInt(this, this.getCurrentRecord());
    }

    public long getLong(int n) throws SQLException {
        return this.findColumnInfo(n).getLong(this, this.getCurrentRecord());
    }

    public long getLong(String string) throws SQLException {
        return this.findColumnInfo(string).getLong(this, this.getCurrentRecord());
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.assertNotClosed();
        return new ResultSetMetaDataSapDB(this.fetchInfo.getColInfo());
    }

    public Object getObject(int n) throws SQLException {
        return this.findColumnInfo(n).getObject(this, this.getCurrentRecord());
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new NotImplemented();
    }

    public Object getObject(String string) throws SQLException {
        return this.findColumnInfo(string).getObject(this, this.getCurrentRecord());
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new NotImplemented();
    }

    public Ref getRef(int n) throws SQLException {
        throw new NotSupportedException(MessageTranslator.translate("error.ref.unsupported"), this);
    }

    public Ref getRef(String string) throws SQLException {
        throw new NotSupportedException(MessageTranslator.translate("error.ref.unsupported"), this);
    }

    public int getRow() throws SQLException {
        this.assertNotClosed();
        if (this.positionState != 2) {
            return 0;
        }
        int n = this.getInternalRow();
        if (n < 0) {
            this.getRowsInResult();
            this.absolute(n);
            n = this.getInternalRow();
        }
        return n;
    }

    public int getInternalRow() {
        if (this.currentChunk != null) {
            return this.currentChunk.getLogicalPos();
        }
        return 0;
    }

    public void traceChunk() {
        System.err.println(this.currentChunk.traceString());
    }

    public short getShort(int n) throws SQLException {
        return this.findColumnInfo(n).getShort(this, this.getCurrentRecord());
    }

    public short getShort(String string) throws SQLException {
        return this.findColumnInfo(string).getShort(this, this.getCurrentRecord());
    }

    public Statement getStatement() throws SQLException {
        this.assertNotClosed();
        if (this.fromMetaData) {
            return null;
        }
        return this.statement;
    }

    public String getString(int n) throws SQLException {
        return this.findColumnInfo(n).getString(this, this.getCurrentRecord());
    }

    public String getString(String string) throws SQLException {
        return this.findColumnInfo(string).getString(this, this.getCurrentRecord());
    }

    public Time getTime(int n) throws SQLException {
        return this.findColumnInfo(n).getTime(this, this.getCurrentRecord(), null);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.findColumnInfo(n).getTime(this, this.getCurrentRecord(), calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.findColumnInfo(string).getTime(this, this.getCurrentRecord(), null);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.findColumnInfo(string).getTime(this, this.getCurrentRecord(), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.findColumnInfo(n).getTimestamp(this, this.getCurrentRecord(), null);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.findColumnInfo(n).getTimestamp(this, this.getCurrentRecord(), calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.findColumnInfo(string).getTimestamp(this, this.getCurrentRecord(), null);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.findColumnInfo(string).getTimestamp(this, this.getCurrentRecord(), calendar);
    }

    public int getType() throws SQLException {
        return this.statement.getResultSetType();
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        InputStream inputStream = this.findColumnInfo(n).getUnicodeStream(this, this.getCurrentRecord());
        if (inputStream != null) {
            this.openStreams.addElement(inputStream);
        }
        return inputStream;
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        InputStream inputStream = this.findColumnInfo(string).getUnicodeStream(this, this.getCurrentRecord());
        if (inputStream != null) {
            this.openStreams.addElement(inputStream);
        }
        return inputStream;
    }

    public Object[] getValues() throws SQLException {
        int n = this.fetchInfo.numberOfColumns();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getObject(i + 1);
        }
        return objectArray;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateInt(String string, int n) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateLong(int n, long l) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateLong(String string, long l) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNull(int n) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNull(String string) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateDefault(String string) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateDefault(int n) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateRow() throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateShort(int n, short s) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateShort(String string, short s) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateString(int n, String string) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateString(String string, String string2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.throwNotUpdatable();
    }

    public void insertRow() throws SQLException {
        this.throwNotUpdatable();
    }

    public void deleteRow() throws SQLException {
        this.throwNotUpdatable();
    }

    public void refreshRow() throws SQLException {
        this.assertNotClosed();
        int n = this.getInternalRow();
        this.initializeFields();
        this.absolute(n);
    }

    public void cancelRowUpdates() throws SQLException {
        this.throwNotUpdatable();
    }

    public void moveToCurrentRow() throws SQLException {
        this.throwNotUpdatable();
    }

    public void moveToInsertRow() throws SQLException {
        this.throwNotUpdatable();
    }

    public String getCursorName() throws SQLException {
        this.assertNotClosed();
        return this.fetchInfo.getCursorName();
    }

    public StructuredMem getReplyData() {
        if (this.currentChunk != null) {
            return this.currentChunk.getReplyData();
        }
        return null;
    }

    public void setLastWasNull(boolean bl) {
        this.lastWasNull = bl;
    }

    void setFromMetaData(boolean bl) {
        this.fromMetaData = bl;
    }

    void setEmpty(boolean bl) {
        this.empty = bl;
    }

    void setRowsInResultSet(int n) throws SQLException {
        this.rowsInResultSet = this.maxRows > 0 ? Math.min(n, this.maxRows) : n;
    }

    private boolean fetchNextChunk() throws SQLException {
        ReplyPacket replyPacket;
        int n = this.fetchSize;
        int n2 = 1;
        if (this.currentChunk.isForward()) {
            if (this.maxRowIsSet()) {
                n = Math.min(this.maxRows - this.currentChunk.getEnd() + 1, n);
            }
            if (this.modifiedKernelPos != 0) {
                n2 += this.currentChunk.getEnd() - this.modifiedKernelPos;
            }
        } else {
            n2 = this.modifiedKernelPos == 0 ? (n2 += this.currentChunk.getEnd() - this.currentChunk.getKernelPos()) : (n2 += this.currentChunk.getEnd() - this.modifiedKernelPos);
        }
        try {
            replyPacket = this.getType() == 1003 ? this.fetchInfo.executeFetchNext(n) : this.fetchInfo.executeFetchRelative(n2, n);
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 100) {
                this.currentChunk.setLast(true);
                this.updateRowStatistics();
                this.currentChunk = null;
                this.positionStateOfChunk = 4;
                this.positionState = 3;
                return false;
            }
            throw sQLException;
        }
        this.setCurrentChunk(new FetchChunk(5, this.currentChunk.getEnd() + 1, replyPacket, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
        return true;
    }

    private boolean fetchLast() throws SQLException {
        if (!this.maxRowIsSet() || this.maxRowsOutSideResult == 1) {
            ReplyPacket replyPacket;
            try {
                replyPacket = this.fetchInfo.executeFetchLast(this.safeFetchSize);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 100) {
                    this.empty = true;
                    this.positionState = 3;
                    this.currentChunk = null;
                    return false;
                }
                throw sQLException;
            }
            try {
                replyPacket.findPart(5);
            }
            catch (PartNotFound partNotFound) {
                throw new InternalJDBCError("Fetch operation delivered no data part");
            }
            this.setCurrentChunk(new FetchChunk(2, -replyPacket.partArguments(), replyPacket, this.fetchInfo.getRecordSize(), 0, this.rowsInResultSet));
            this.currentChunk.moveToUpperBound();
            return true;
        }
        if (this.rowsInResultSetKnown()) {
            ReplyPacket replyPacket;
            int n = this.safeFetchSize;
            int n2 = this.rowsInResultSet - n + 1;
            try {
                replyPacket = this.fetchInfo.executeFetchAbsolute(n2, n);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 100) {
                    this.rowsInResultSet = -1;
                    return this.fetchLast();
                }
                throw sQLException;
            }
            this.setCurrentChunk(new FetchChunk(3, n2, replyPacket, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
            this.currentChunk.moveToUpperBound();
            return true;
        }
        try {
            ReplyPacket replyPacket = this.fetchInfo.executeFetchAbsolute(this.maxRows, 1);
            this.setCurrentChunk(new FetchChunk(3, this.maxRows, replyPacket, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
            this.currentChunk.moveToUpperBound();
            return true;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 100) {
                throw sQLException;
            }
            this.maxRowsOutSideResult = 1;
            return this.fetchLast();
        }
    }

    private boolean fetchFirst() throws SQLException {
        ReplyPacket replyPacket;
        int n = this.fetchSize;
        if (this.maxRowIsSet()) {
            n = Math.min(n, this.maxRows);
        }
        try {
            replyPacket = this.statement.resultSetType == 1003 ? this.fetchInfo.executeFetchNext(n) : this.fetchInfo.executeFetchFirst(n);
        }
        catch (SQLExceptionSapDB sQLExceptionSapDB) {
            if (sQLExceptionSapDB.getErrorCode() != 100) {
                throw sQLExceptionSapDB;
            }
            this.empty = true;
            this.positionState = 3;
            this.currentChunk = null;
            return false;
        }
        this.setCurrentChunk(new FetchChunk(1, 1, replyPacket, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
        return true;
    }

    private boolean fetchAbsoluteDown(int n) throws SQLException {
        if (this.maxRowIsSet()) {
            if (this.maxRowsOutSideResult == -1) {
                if (this.rowsInResultSet == -1) {
                    throw new InternalJDBCError(MessageTranslator.translate("error.assertion.maxrowsinresult"));
                }
                int n2 = this.maxRows + n + 1;
                if (n2 <= 0) {
                    this.positionState = 1;
                    return false;
                }
                return this.absolute(n2);
            }
            if (this.maxRowsOutSideResult == 0) {
                try {
                    ReplyPacket replyPacket = this.fetchInfo.executeFetchAbsolute(this.maxRows, 1);
                    this.setCurrentChunk(new FetchChunk(3, this.maxRows, replyPacket, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
                    this.currentChunk.moveToUpperBound();
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() != 100) {
                        throw sQLException;
                    }
                    this.maxRowsOutSideResult = 1;
                    return this.absolute(n);
                }
                this.maxRowsOutSideResult = -1;
                return this.absolute(n);
            }
            ReplyPacket replyPacket = null;
            try {
                replyPacket = this.fetchInfo.executeFetchAbsolute(n, this.fetchSize);
            }
            catch (SQLExceptionSapDB sQLExceptionSapDB) {
                if (sQLExceptionSapDB.getErrorCode() == 100) {
                    this.positionState = 1;
                    return false;
                }
                throw sQLExceptionSapDB;
            }
            this.setCurrentChunk(new FetchChunk(4, n, replyPacket, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
            if (!this.currentChunk.setRow(n)) {
                this.positionState = 1;
                return false;
            }
            return true;
        }
        ReplyPacket replyPacket = null;
        try {
            replyPacket = this.fetchInfo.executeFetchAbsolute(n, this.fetchSize);
        }
        catch (SQLExceptionSapDB sQLExceptionSapDB) {
            if (sQLExceptionSapDB.getErrorCode() == 100) {
                this.positionState = 1;
                return false;
            }
            throw sQLExceptionSapDB;
        }
        this.setCurrentChunk(new FetchChunk(4, n, replyPacket, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
        if (!this.currentChunk.setRow(n)) {
            this.positionState = 1;
            return false;
        }
        return true;
    }

    private boolean fetchAbsoluteUp(int n, boolean bl) throws SQLException {
        ReplyPacket replyPacket;
        int n2 = this.maxRowIsSet() ? (this.rowsInResultSetKnown() ? Math.min(this.maxRows, this.rowsInResultSet) : this.maxRows) : (this.rowsInResultSetKnown() ? this.rowsInResultSet : Integer.MAX_VALUE);
        int n3 = this.fetchSize;
        int n4 = n;
        if (bl && this.safeFetchSizeDetermined) {
            n3 = this.safeFetchSize;
            n4 = n - n3 + 1;
            if (n4 <= 0) {
                n4 = 1;
            }
        } else if (n + n3 > n2 && n3 <= this.safeFetchSize) {
            n4 = n2 - n3 + 1;
        }
        try {
            replyPacket = this.fetchInfo.executeFetchAbsolute(n4, n3);
        }
        catch (SQLExceptionSapDB sQLExceptionSapDB) {
            if (sQLExceptionSapDB.getErrorCode() != 100) {
                throw sQLExceptionSapDB;
            }
            this.positionState = 3;
            return false;
        }
        this.setCurrentChunk(new FetchChunk(3, n4, replyPacket, this.fetchInfo.getRecordSize(), this.maxRows, this.rowsInResultSet));
        if (n4 != n && !this.currentChunk.setRow(n)) {
            this.positionState = 3;
            return false;
        }
        return true;
    }

    private boolean maxRowIsSet() {
        return this.maxRows != 0;
    }

    private boolean rowsInResultSetKnown() {
        return this.rowsInResultSet != -1;
    }

    private void assertNotForwardOnly() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.resultset.forwardonly"));
        }
    }

    protected void assertNotClosed() throws SQLException {
        super.assertOpen();
        if (this.isClosed) {
            throw new ObjectIsClosedException(this);
        }
    }

    protected final DBTechTranslator findColumnInfo(String string) throws SQLException {
        this.assertNotClosed();
        DBTechTranslator dBTechTranslator = this.fetchInfo.getColumnInfo(string);
        if (dBTechTranslator == null) {
            throw new InvalidColumnException(string, (Object)this);
        }
        return dBTechTranslator;
    }

    protected final DBTechTranslator[] getColInfo() throws SQLException {
        return this.fetchInfo.getColInfo();
    }

    protected final int numberOfColumns() {
        return this.fetchInfo.numberOfColumns();
    }

    protected final StructuredMem getCurrentRecord() throws SQLException {
        if (this.positionState == 1) {
            throw new JDBCDriverException(MessageTranslator.translate("error.resultset.beforefirst"));
        }
        if (this.positionState == 3) {
            throw new JDBCDriverException(MessageTranslator.translate("error.resultset.afterlast"));
        }
        return this.currentChunk.getCurrentRecord();
    }

    private DBTechTranslator findColumnInfo(int n) throws SQLException {
        DBTechTranslator dBTechTranslator;
        this.assertNotClosed();
        try {
            dBTechTranslator = this.getColInfo()[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidColumnException(n, (Object)this);
        }
        return dBTechTranslator;
    }

    private void throwNotUpdatable() throws JDBCDriverException {
        throw new JDBCDriverException(MessageTranslator.translate("error.resultset.notupdatable"), this);
    }

    private void closeOpenStreams() {
        Enumeration enumeration = this.openStreams.elements();
        while (enumeration.hasMoreElements()) {
            try {
                Object e = enumeration.nextElement();
                try {
                    InputStream inputStream = (InputStream)e;
                    inputStream.close();
                }
                catch (ClassCastException classCastException) {
                    Reader reader = (Reader)e;
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.openStreams.clear();
    }

    private void setCurrentChunk(FetchChunk fetchChunk) throws SQLException {
        this.positionStateOfChunk = 2;
        this.positionState = 2;
        this.currentChunk = fetchChunk;
        int n = Math.min(this.fetchSize, Math.max(fetchChunk.size(), this.safeFetchSize));
        if (this.safeFetchSize != n) {
            this.safeFetchSize = n;
            this.safeFetchSizeDetermined = false;
        } else {
            this.safeFetchSizeDetermined = n != 1;
        }
        this.modifiedKernelPos = 0;
        this.updateRowStatistics();
    }

    private void updateRowStatistics() throws SQLException {
        if (!this.rowsInResultSetKnown()) {
            if (this.currentChunk.isLast() && this.currentChunk.isFirst()) {
                this.setRowsInResultSet(this.currentChunk.size());
                this.currentChunk.setRowsInResultSet(this.rowsInResultSet);
            } else if (this.currentChunk.isLast() && this.currentChunk.isForward()) {
                this.setRowsInResultSet(this.currentChunk.getEnd());
                this.currentChunk.setRowsInResultSet(this.rowsInResultSet);
            } else if (this.currentChunk.isFirst() && !this.currentChunk.isForward()) {
                this.setRowsInResultSet(-this.currentChunk.getStart());
                this.currentChunk.setRowsInResultSet(this.rowsInResultSet);
            } else if (this.currentChunk.isForward()) {
                this.largestKnownAbsPos = Math.max(this.largestKnownAbsPos, this.currentChunk.getEnd());
            }
        }
    }

    private int invertPosition(int n) {
        return this.rowsInResultSet + n + 1;
    }

    private void printPosInfo(int n, int n2, int n3, int n4) {
        System.err.println("---------------------------------------------------");
        System.err.println("LARGEST KNOWN POS: " + n);
        System.err.println("SMALLEST BAD  POS: " + n2);
        System.err.println("STEP SIZE        : " + n3);
        System.err.println("POSITION         : " + n4);
    }

    private void getRowsInResult() throws SQLException {
        int n = 32;
        int n2 = this.largestKnownAbsPos;
        int n3 = Integer.MAX_VALUE;
        try {
            this.fetchInfo.executeFetchAbsolute(this.largestKnownAbsPos, 1);
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 100) {
                if (this.largestKnownAbsPos == 1) {
                    this.empty = true;
                    this.positionState = 1;
                    return;
                }
                this.largestKnownAbsPos = 1;
                this.getRowsInResult();
                return;
            }
            throw sQLException;
        }
        while (true) {
            if (this.maxRows != 0 && n2 + n > this.maxRows) {
                n = this.maxRows - n2;
            }
            try {
                this.fetchInfo.executeFetchAbsolute(n2 + n, 1);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 100) {
                    if (n == 1) {
                        this.setRowsInResultSet(n2);
                        this.currentChunk = null;
                        this.positionState = 1;
                        this.positionStateOfChunk = 4;
                        return;
                    }
                    n3 = n2 + n;
                    if ((n /= 2) != 0) continue;
                    n = 1;
                    continue;
                }
                throw sQLException;
            }
            if ((n *= 2) >= n3 - (n2 += n) && (n = (n3 - n2) / 2) == 0) {
                n = 1;
            }
            if (this.maxRows != 0 && n2 == this.maxRows) break;
        }
        this.setRowsInResultSet(n2);
        this.currentChunk = null;
        this.positionState = 1;
        this.positionStateOfChunk = 4;
    }

    public URL getURL(int n) throws SQLException {
        throw new NotSupportedException(MessageTranslator.translate("error.url.unsupported"), this);
    }

    public URL getURL(String string) throws SQLException {
        throw new NotSupportedException(MessageTranslator.translate("error.url.unsupported"), this);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new NotSupportedException(MessageTranslator.translate("error.ref.unsupported"), this);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new NotSupportedException(MessageTranslator.translate("error.ref.unsupported"), this);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new NotSupportedException(MessageTranslator.translate("error.array.unsupported"), this);
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new NotSupportedException(MessageTranslator.translate("error.array.unsupported"), this);
    }

    public AbstractABAPStreamGetval getOMSGetval(int n) {
        return null;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.finalize();
    }

    public void cancel() throws SQLException {
    }
}

