/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.AbstractProcedurePutval;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.InputStreamFilter;
import com.sap.dbtech.util.MessageTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

abstract class BasisProcedurePutval
extends AbstractProcedurePutval {
    protected InputStream stream;
    protected boolean marksupported;
    protected int length;
    protected boolean atBegin = true;

    public BasisProcedurePutval(DBTechTranslator dBTechTranslator, InputStream inputStream, int n) {
        super(dBTechTranslator);
        if (n == -1) {
            this.stream = inputStream;
            this.marksupported = this.stream.markSupported();
            this.length = Integer.MAX_VALUE;
        } else {
            this.stream = new InputStreamFilter(inputStream, n);
            this.marksupported = this.stream.markSupported();
            this.length = n;
        }
        if (this.marksupported) {
            this.stream.mark(this.length);
        }
    }

    public void transferStream(DataPart dataPart, short s) throws SQLException {
        if (s == -2) {
            if (!this.atBegin) {
                if (this.marksupported) {
                    try {
                        this.stream.reset();
                        this.atBegin = true;
                        this.stream.mark(this.length);
                    }
                    catch (IOException iOException) {
                        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
                    }
                } else {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.reset.stream"));
                }
            }
            s = Short.MAX_VALUE;
        } else if (this.atBegin && this.marksupported) {
            this.stream.mark(this.length);
        }
        if (dataPart.fillWithProcedureStream(this.stream, s)) {
            // empty if block
        }
        this.atBegin = false;
    }

    public void closeStream() throws SQLExceptionSapDB {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
        }
    }
}

