/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.translators.ABAPStreamTranslator;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamGetval;
import com.sap.dbtech.util.MessageTranslator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BinaryABAPStreamGetval
extends AbstractABAPStreamGetval {
    public BinaryABAPStreamGetval(ABAPStreamTranslator aBAPStreamTranslator) {
        super(aBAPStreamTranslator);
        this.addColumn(1, 14, 1, 0, 1, 0);
    }

    public byte[] getBytes() throws SQLException {
        if (this.data == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.nodata"));
        }
        return this.data.bytes();
    }

    public Object getObject() throws SQLException {
        return this.getBytes();
    }

    public Blob getBlob() throws SQLException {
        if (this.data == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.nodata"));
        }
        return new BlobImplementation(this.data.bytes());
    }

    static class BlobImplementation
    implements Blob {
        byte[] data;

        BlobImplementation(byte[] byArray) {
            this.data = byArray;
        }

        public long length() throws SQLException {
            return this.data.length;
        }

        public void truncate(long l) throws SQLException {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.blob.unsupported", "truncate"));
        }

        public byte[] getBytes(long l, int n) throws SQLException {
            if (l > (long)this.data.length || l < 1L) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.invalid.blob.position", new Long(l)));
            }
            int n2 = (int)Math.min((long)n, (long)(this.data.length + 1) - l);
            byte[] byArray = new byte[n2];
            System.arraycopy(this.data, (int)(l - 1L), byArray, 0, n2);
            return byArray;
        }

        public int setBytes(long l, byte[] byArray) throws SQLException {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.blob.unsupported", "setBytes"));
        }

        public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.blob.unsupported", "setBytes"));
        }

        public long position(byte[] byArray, long l) throws SQLException {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.blob.unsupported", "position"));
        }

        public InputStream getBinaryStream() throws SQLException {
            return new ByteArrayInputStream(this.data);
        }

        public OutputStream setBinaryStream(long l) throws SQLException {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.blob.unsupported", "setBinaryStream"));
        }

        public long position(Blob blob, long l) throws SQLException {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.blob.unsupported", "position"));
        }
    }
}

