/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.powertoys;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.powertoys.LoaderException;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.NativeComm;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.SocketComm;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import java.sql.SQLException;
import java.util.Properties;

public class Loader {
    public static final String hostKeyC = "host";
    private static final String hostDefaultC = "";
    public static final String dbnameKeyC = "dbname";
    private static final String dbnameDefaultC = "";
    public static final String dbrootKeyC = "dbroot";
    private static final String dbrootDefaultC = "";
    public static final String userKeyC = "user";
    private static final String pgmNameC = "lserver";
    private static final String transportC = "transport";
    private static final int alignSizeC = 8;
    static final int indicatorLengthC = 4;
    private JdbcCommunication connection;
    private boolean inCommunication;

    public Loader(Properties properties) throws RTEException {
        String string = properties.getProperty(hostKeyC, "");
        String string2 = properties.getProperty(dbnameKeyC, "");
        String string3 = properties.getProperty(dbrootKeyC, "");
        String string4 = properties.getProperty(transportC, "socket");
        JdbcCommFactory jdbcCommFactory = null;
        try {
            try {
                jdbcCommFactory = DriverSapDB.loadNativeCommunication() == 2 ? NativeComm.factory : SocketComm.factory;
                DriverSapDB.openTrace("", properties);
                Tracer.print("new Loader Connection ", properties);
                this.connection = jdbcCommFactory.xopen(string, string2, string3, pgmNameC, properties);
            }
            catch (Error error) {
                jdbcCommFactory = SocketComm.factory;
                this.connection = jdbcCommFactory.xopen(string, string2, string3, pgmNameC, properties);
            }
        }
        catch (RTEException rTEException) {
            Tracer.println("using " + jdbcCommFactory);
            Tracer.println("=> FAILED");
            throw rTEException;
        }
        Tracer.println("using " + this.connection);
        Tracer.println("=> " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws RTEException {
        Tracer.println(this + "->release ()");
        if (this.connection != null) {
            try {
                try {
                    this.cmd("release");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connection.release();
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void finalize() throws RTEException {
        this.release();
    }

    public String cmd(String string) throws RTEException, LoaderException {
        Tracer.println(this + "->cmd (" + string + ")");
        try {
            int n;
            StructuredMem structuredMem = this.connection.getRequestPacket();
            if (string.length() == 0) {
                structuredMem.putBytes(new byte[]{0}, 0);
                n = 8;
            } else {
                structuredMem.putString(string, 0);
                n = (string.length() + 8 - 1) / 8 * 8;
            }
            this.connection.request(structuredMem, n);
            this.inCommunication = true;
            StructuredMem structuredMem2 = this.connection.receive();
            this.inCommunication = false;
            String string2 = structuredMem2.getString(0, Math.min(4, structuredMem2.size()));
            if (!string2.startsWith("OK")) {
                throw LoaderException.create(structuredMem2);
            }
            int n2 = string2.indexOf(10) + 1;
            String string3 = structuredMem2.getString(n2, structuredMem2.size() - n2);
            Tracer.println("=> " + string3);
            String string4 = string3;
            return string4;
        }
        catch (LoaderException loaderException) {
            Tracer.println(" <-!");
            Tracer.traceException(loaderException);
            throw loaderException;
        }
        catch (RTEException rTEException) {
            Tracer.println(" <-!");
            Tracer.traceException(rTEException);
            throw rTEException;
        }
        finally {
            this.inCommunication = false;
        }
    }

    public void cancel() throws SQLException {
        if (this.inCommunication) {
            this.connection.cancel();
        }
    }

    public static Loader dbLoader(String string, String string2) throws RTEException {
        Properties properties = new Properties();
        if (string != null) {
            properties.put(hostKeyC, string);
        }
        if (string2 != null) {
            properties.put(dbnameKeyC, string2);
        }
        return new Loader(properties);
    }

    public static Loader dbrootLoader(String string, String string2) throws RTEException {
        Properties properties = new Properties();
        if (string != null) {
            properties.put(hostKeyC, string);
        }
        properties.put(dbrootKeyC, string2);
        return new Loader(properties);
    }
}

