/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.ArrayList;
import java.util.Collections;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.util.Cache;
import org.h2.util.CacheHead;
import org.h2.util.CacheObject;
import org.h2.util.CacheSecondLevel;
import org.h2.util.CacheWriter;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.SoftHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheLRU
implements Cache {
    static final String TYPE_NAME = "LRU";
    private final CacheWriter writer;
    private final CacheObject head = new CacheHead();
    private final int len;
    private final int mask;
    private int maxSize;
    private CacheObject[] values;
    private int recordCount;
    private int sizeMemory;

    private CacheLRU(CacheWriter cacheWriter, int n) {
        this.maxSize = n * 1024 / 4;
        this.writer = cacheWriter;
        this.len = MathUtils.nextPowerOf2(this.maxSize / 64);
        this.mask = this.len - 1;
        MathUtils.checkPowerOf2(this.len);
        this.clear();
    }

    public static Cache getCache(CacheWriter cacheWriter, String string, int n) {
        SoftHashMap<Integer, CacheObject> softHashMap = null;
        if (string.startsWith("SOFT_")) {
            softHashMap = new SoftHashMap<Integer, CacheObject>();
            string = string.substring("SOFT_".length());
        }
        if (!TYPE_NAME.equals(string)) {
            throw DbException.getInvalidValueException(string, "CACHE_TYPE");
        }
        Cache cache = new CacheLRU(cacheWriter, n);
        if (softHashMap != null) {
            cache = new CacheSecondLevel(cache, softHashMap);
        }
        return cache;
    }

    @Override
    public void clear() {
        this.head.cacheNext = this.head.cachePrevious = this.head;
        this.values = null;
        this.values = new CacheObject[this.len];
        this.recordCount = 0;
        this.sizeMemory = 0;
    }

    @Override
    public void put(CacheObject cacheObject) {
        int n;
        CacheObject cacheObject2;
        if (SysProperties.CHECK && (cacheObject2 = this.find(n = cacheObject.getPos())) != null) {
            DbException.throwInternalError("try to add a record twice pos:" + n);
        }
        n = cacheObject.getPos() & this.mask;
        cacheObject.cacheChained = this.values[n];
        this.values[n] = cacheObject;
        ++this.recordCount;
        this.sizeMemory += cacheObject.getMemorySize();
        this.addToFront(cacheObject);
        this.removeOldIfRequired();
    }

    @Override
    public CacheObject update(int n, CacheObject cacheObject) {
        CacheObject cacheObject2 = this.find(n);
        if (cacheObject2 == null) {
            this.put(cacheObject);
        } else {
            if (SysProperties.CHECK && cacheObject2 != cacheObject) {
                DbException.throwInternalError("old!=record pos:" + n + " old:" + cacheObject2 + " new:" + cacheObject);
            }
            this.removeFromLinkedList(cacheObject);
            this.addToFront(cacheObject);
        }
        return cacheObject2;
    }

    private void removeOldIfRequired() {
        if (this.sizeMemory >= this.maxSize) {
            this.removeOld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOld() {
        int n = 0;
        ArrayList arrayList = New.arrayList();
        int n2 = this.sizeMemory;
        int n3 = this.recordCount;
        boolean bl = false;
        CacheObject cacheObject = this.head.cacheNext;
        while (n2 * 4 > this.maxSize * 3 && n3 > 16) {
            CacheObject cacheObject2 = cacheObject;
            cacheObject = cacheObject2.cacheNext;
            if (++n >= this.recordCount) {
                if (!bl) {
                    this.writer.flushLog();
                    bl = true;
                    n = 0;
                } else {
                    this.writer.getTrace().info("Cannot remove records, cache size too small? records:" + this.recordCount + " memory:" + this.sizeMemory);
                    break;
                }
            }
            if (SysProperties.CHECK && cacheObject2 == this.head) {
                DbException.throwInternalError("try to remove head");
            }
            if (!cacheObject2.canRemove()) {
                this.removeFromLinkedList(cacheObject2);
                this.addToFront(cacheObject2);
                continue;
            }
            --n3;
            n2 -= cacheObject2.getMemorySize();
            if (cacheObject2.isChanged()) {
                arrayList.add(cacheObject2);
                continue;
            }
            this.remove(cacheObject2.getPos());
        }
        if (arrayList.size() > 0) {
            CacheObject cacheObject3;
            Collections.sort(arrayList);
            int n4 = this.maxSize;
            try {
                this.maxSize = Integer.MAX_VALUE;
                for (n = 0; n < arrayList.size(); ++n) {
                    cacheObject3 = (CacheObject)arrayList.get(n);
                    this.writer.writeBack(cacheObject3);
                }
            }
            finally {
                this.maxSize = n4;
            }
            for (n = 0; n < arrayList.size(); ++n) {
                cacheObject3 = (CacheObject)arrayList.get(n);
                this.remove(cacheObject3.getPos());
                if (!SysProperties.CHECK || cacheObject3.cacheNext == null) continue;
                throw DbException.throwInternalError();
            }
        }
    }

    private void addToFront(CacheObject cacheObject) {
        if (SysProperties.CHECK && cacheObject == this.head) {
            DbException.throwInternalError("try to move head");
        }
        cacheObject.cacheNext = this.head;
        cacheObject.cachePrevious = this.head.cachePrevious;
        cacheObject.cachePrevious.cacheNext = cacheObject;
        this.head.cachePrevious = cacheObject;
    }

    private void removeFromLinkedList(CacheObject cacheObject) {
        if (SysProperties.CHECK && cacheObject == this.head) {
            DbException.throwInternalError("try to remove head");
        }
        cacheObject.cachePrevious.cacheNext = cacheObject.cacheNext;
        cacheObject.cacheNext.cachePrevious = cacheObject.cachePrevious;
        cacheObject.cacheNext = null;
        cacheObject.cachePrevious = null;
    }

    @Override
    public void remove(int n) {
        CacheObject cacheObject;
        int n2 = n & this.mask;
        CacheObject cacheObject2 = this.values[n2];
        if (cacheObject2 == null) {
            return;
        }
        if (cacheObject2.getPos() == n) {
            this.values[n2] = cacheObject2.cacheChained;
        } else {
            do {
                cacheObject = cacheObject2;
                cacheObject2 = cacheObject2.cacheChained;
                if (cacheObject2 != null) continue;
                return;
            } while (cacheObject2.getPos() != n);
            cacheObject.cacheChained = cacheObject2.cacheChained;
        }
        --this.recordCount;
        this.sizeMemory -= cacheObject2.getMemorySize();
        this.removeFromLinkedList(cacheObject2);
        if (SysProperties.CHECK) {
            cacheObject2.cacheChained = null;
            cacheObject = this.find(n);
            if (cacheObject != null) {
                DbException.throwInternalError("not removed: " + cacheObject);
            }
        }
    }

    @Override
    public CacheObject find(int n) {
        CacheObject cacheObject = this.values[n & this.mask];
        while (cacheObject != null && cacheObject.getPos() != n) {
            cacheObject = cacheObject.cacheChained;
        }
        return cacheObject;
    }

    @Override
    public CacheObject get(int n) {
        CacheObject cacheObject = this.find(n);
        if (cacheObject != null) {
            this.removeFromLinkedList(cacheObject);
            this.addToFront(cacheObject);
        }
        return cacheObject;
    }

    @Override
    public ArrayList<CacheObject> getAllChanged() {
        ArrayList<CacheObject> arrayList = New.arrayList();
        CacheObject cacheObject = this.head.cacheNext;
        while (cacheObject != this.head) {
            if (cacheObject.isChanged()) {
                arrayList.add(cacheObject);
            }
            cacheObject = cacheObject.cacheNext;
        }
        return arrayList;
    }

    @Override
    public void setMaxSize(int n) {
        int n2 = n * 1024 / 4;
        this.maxSize = n2 < 0 ? 0 : n2;
        this.removeOldIfRequired();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int getSize() {
        return this.sizeMemory;
    }
}

