/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueByte
extends Value {
    static final int PRECISION = 3;
    static final int DISPLAY_SIZE = 4;
    private final byte value;

    private ValueByte(byte by) {
        this.value = by;
    }

    public Value add(Value value) {
        ValueByte valueByte = (ValueByte)value;
        return this.checkRange(this.value + valueByte.value);
    }

    private ValueByte checkRange(int n) {
        if (n < -128 || n > 127) {
            throw DbException.get(90110, DataType.getDataType((int)2).name);
        }
        return ValueByte.get((byte)n);
    }

    public int getSignum() {
        return Integer.signum(this.value);
    }

    public Value negate() {
        return this.checkRange(-this.value);
    }

    public Value subtract(Value value) {
        ValueByte valueByte = (ValueByte)value;
        return this.checkRange(this.value - valueByte.value);
    }

    public Value multiply(Value value) {
        ValueByte valueByte = (ValueByte)value;
        return this.checkRange(this.value * valueByte.value);
    }

    public Value divide(Value value) {
        ValueByte valueByte = (ValueByte)value;
        if (valueByte.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueByte.get((byte)(this.value / valueByte.value));
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 2;
    }

    public byte getByte() {
        return this.value;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueByte valueByte = (ValueByte)value;
        return MathUtils.compareInt(this.value, valueByte.value);
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 3L;
    }

    public int hashCode() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setByte(n, this.value);
    }

    public static ValueByte get(byte by) {
        return (ValueByte)Value.cache(new ValueByte(by));
    }

    public int getDisplaySize() {
        return 4;
    }

    public boolean equals(Object object) {
        return object instanceof ValueByte && this.value == ((ValueByte)object).value;
    }
}

