/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.Dataholder;
import com.intersys.cache.jbind.CacheProcessor;
import com.intersys.cache.jbind.SerializationSupport;
import com.intersys.cache.jbind.ZObjectValueRep;
import com.intersys.jdbc.SysListProxy;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Deserializer
extends SerializationSupport {
    private Map objects = new HashMap();
    private Object input;

    public Deserializer(PrintWriter printWriter) {
        this(null, printWriter);
    }

    public Deserializer(Map map, PrintWriter printWriter) {
        super(map, printWriter);
    }

    public Object unmarshall(String string, Object object, Map map) throws SQLException, ClassNotFoundException {
        this.input = object;
        int n = this.processOref();
        Class<?> clazz = Class.forName(string);
        Object object2 = this.instantiate(n, clazz, map);
        return object2;
    }

    public Map processObject(Object object) throws SQLException {
        int n = SysListProxy.getInteger(object);
        HashMap hashMap = new HashMap(n);
        if (this.logger != null) {
            this.logger.println("Got object; nnodes=" + n);
        }
        for (int i = 0; i < n; ++i) {
            CacheProcessor.processNode(hashMap, object, this.logger);
        }
        return hashMap;
    }

    private int processOref() throws SQLException {
        String string = SysListProxy.getString(this.input);
        int n = string.indexOf(64);
        int n2 = Integer.parseInt(string.substring(0, n));
        String string2 = string.substring(n + 1);
        int n3 = SysListProxy.getInteger(this.input);
        HashMap hashMap = new HashMap(n3);
        if (this.logger != null) {
            this.logger.println("Got oref=" + n2 + "; nnodes=" + n3);
        }
        for (int i = 0; i < n3; ++i) {
            CacheProcessor.processNode(hashMap, this.input, this.logger);
        }
        ZObjectValueRep zObjectValueRep = new ZObjectValueRep(hashMap, null);
        this.objects.put(new Integer(n2), zObjectValueRep);
        return n2;
    }

    private Object instantiate(int n, Class clazz, Map map) throws SQLException {
        ZObjectValueRep zObjectValueRep;
        if (this.logger != null) {
            this.logger.println("Instantiating <" + clazz.getName() + ">." + n);
        }
        if ((zObjectValueRep = (ZObjectValueRep)this.objects.get(new Integer(n))) == null) {
            if (this.logger != null) {
                this.logger.println("Looking for oref " + n + " in input");
            }
            int n2 = 0;
            while ((n2 = this.processOref()) != n) {
            }
            zObjectValueRep = (ZObjectValueRep)this.objects.get(new Integer(n));
        }
        Map map2 = this.getMetaData(map, clazz);
        try {
            int n3;
            Object t = clazz.newInstance();
            Field[] fieldArray = clazz.getFields();
            HashSet<String> hashSet = new HashSet<String>();
            for (n3 = 0; n3 < fieldArray.length; ++n3) {
                hashSet.add(fieldArray[n3].getName());
            }
            for (n3 = 0; n3 < fieldArray.length; ++n3) {
                Field field = fieldArray[n3];
                if (this.logger != null) {
                    this.logger.println("Setting field " + field.getName());
                }
                Object object = this.getValue(zObjectValueRep, field, map2, hashSet, map);
                field.set(t, object);
            }
            if (this.logger != null) {
                this.logger.println("Done <" + clazz.getName() + ">." + n);
            }
            return t;
        }
        catch (Exception exception) {
            if (this.logger != null) {
                exception.printStackTrace(this.logger);
            }
            throw new SQLException("Failed to instantiate object of class " + clazz.getName() + ": " + exception.getMessage());
        }
    }

    private Object getValue(ZObjectValueRep zObjectValueRep, Field field, Map map, Set set, Map map2) throws Exception {
        String string = field.getName();
        String string2 = this.mNameMapper.cacheFieldNameFor(field, set);
        SerializationSupport.Metadata metadata = (SerializationSupport.Metadata)map.get(string2);
        if (metadata == null) {
            throw new Exception("No metadata for field " + string + '/' + string2);
        }
        Dataholder dataholder = zObjectValueRep.getProperty(metadata.ii, metadata.jj);
        if (metadata.isObj) {
            String string3 = dataholder.getString();
            if (string3 == null || string3.length() == 0) {
                return null;
            }
            int n = string3.indexOf(64);
            int n2 = Integer.parseInt(string3.substring(0, n));
            String string4 = string3.substring(n + 1);
            Object object = this.instantiate(n2, field.getType(), map2);
            return object;
        }
        return dataholder.getObject(field.getType().getName());
    }
}

